/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import dev.tocraft.walkers.network.impl.SwapVariantPackets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpecialShapeWidget
extends AbstractButton {
    private final Screen parent;
    private final boolean isCurrent;
    private final boolean isAvailable;

    public SpecialShapeWidget(int x, int y, int width, int height, Screen parent) {
        super(x, y, width, height, Component.nullToEmpty((String)""));
        LivingEntity livingEntity;
        this.parent = parent;
        assert (Minecraft.getInstance().level != null);
        TagValueOutput out = TagValueOutput.createWithContext((ProblemReporter)Walkers.PROBLEM_REPORTER, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        if (Minecraft.getInstance().player != null && (livingEntity = PlayerShape.getCurrentShape((Player)Minecraft.getInstance().player)) instanceof Wolf) {
            Wolf wolf = (Wolf)livingEntity;
            wolf.saveWithoutId((ValueOutput)out);
        }
        this.isCurrent = out.buildResult().getBooleanOr("isSpecial", false);
        this.isAvailable = Minecraft.getInstance().player != null && Remorphed.canUseShape((Player)Minecraft.getInstance().player, EntityType.WOLF);
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.isAvailable ? "remorphed.special_shape_available" : "remorphed.special_shape_unavailable"))));
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/wolf.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 15, 15, 15, 15);
        if (!this.isCurrent && !this.isAvailable) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/unavailable.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 15, 15, 15, 15);
        }
        if (this.isHoveredOrFocused()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/head_focus.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 16, 16, 16, 16);
        }
    }

    public void onPress() {
        UUID profileId = Minecraft.getInstance().getUser().getProfileId();
        if (!this.isCurrent && this.isAvailable && Walkers.hasSpecialShape((UUID)profileId)) {
            TypeProvider typeProvider = TypeProviderRegistry.getProvider((EntityType)EntityType.WOLF);
            int range = typeProvider != null ? typeProvider.size((Level)Minecraft.getInstance().level) : -1;
            NetworkHandler.sendSwap2ndShapeRequest(Objects.requireNonNull(ShapeType.from((EntityType)EntityType.WOLF, (int)-1)));
            SwapVariantPackets.sendSwapRequest((int)range);
            this.parent.onClose();
        }
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

