/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed;

import com.mojang.authlib.GameProfile;
import dev.tocraft.craftedcore.config.Config;
import dev.tocraft.craftedcore.config.ConfigLoader;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.craftedcore.event.common.EntityEvents;
import dev.tocraft.craftedcore.event.common.PlayerEvents;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.craftedcore.platform.VersionChecker;
import dev.tocraft.remorphed.RemorphedClient;
import dev.tocraft.remorphed.command.RemorphedCommand;
import dev.tocraft.remorphed.config.RemorphedConfig;
import dev.tocraft.remorphed.handler.LivingDeathHandler;
import dev.tocraft.remorphed.handler.PlayerRespawnHandler;
import dev.tocraft.remorphed.handler.SwapShapeCallback;
import dev.tocraft.remorphed.handler.UnlockShapeCallback;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.events.ShapeEvents;
import dev.tocraft.walkers.api.platform.ApiLevel;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Remorphed {
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = (RemorphedConfig)ConfigLoader.register((String)"remorphed", (Config[])new RemorphedConfig[0]);
    public static boolean displayDataInMenu = Remorphed.CONFIG.show_traits_by_default;
    @ApiStatus.Internal
    public static final boolean foundSkinShifter = PlatformData.isModLoaded((String)"skinshifter");

    public void initialize() {
        ShapeEvents.UNLOCK_SHAPE.register((Object)new UnlockShapeCallback());
        ShapeEvents.SWAP_SHAPE.register((Object)new SwapShapeCallback());
        if (!Remorphed.CONFIG.unlockFriendlyNormal) {
            ApiLevel.setApiLevel((ApiLevel)ApiLevel.MORPHING_AND_VARIANTS_MENU_ONLY);
        }
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));
        Walkers.devs.add(UUID.fromString("d014c6c7-1c15-46b7-94e1-a5dd28f9425e"));
        VersionChecker.registerModrinthChecker((String)MODID, (String)MODID, (class_2561)class_2561.method_43470((String)"Remorphed"));
        if (PlatformData.getEnv() == EnvType.CLIENT) {
            new RemorphedClient().initialize();
        }
        NetworkHandler.registerPacketReceiver();
        CommandEvents.REGISTRATION.register((Object)new RemorphedCommand());
        EntityEvents.LIVING_DEATH.register((Object)new LivingDeathHandler());
        PlayerEvents.PLAYER_RESPAWN.register((Object)new PlayerRespawnHandler());
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();
        PlayerEvents.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseEveryShape(@NotNull class_1657 player) {
        return player.method_68878() && Remorphed.CONFIG.creativeUnlockAll;
    }

    public static boolean canUseShape(class_1657 player, ShapeType<?> type) {
        if (Remorphed.CONFIG.usePermissions && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!PermissionManager.canMorph(serverPlayer)) {
                return false;
            }
            if (type != null && !PermissionManager.canMorphIntoType(serverPlayer, type.getEntityType())) {
                return false;
            }
            if (Remorphed.CONFIG.lockTransform && !PermissionManager.canBypassTransformLock(serverPlayer)) {
                return false;
            }
            if (Remorphed.canUseEveryShape(player)) {
                return true;
            }
            return !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type.getEntityType()));
        }
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type.getEntityType()));
    }

    public static boolean canUseShape(class_1657 player, class_1299<?> type) {
        if (Remorphed.CONFIG.usePermissions && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!PermissionManager.canMorph(serverPlayer)) {
                return false;
            }
            if (type != null && !PermissionManager.canMorphIntoType(serverPlayer, type)) {
                return false;
            }
            if (Remorphed.CONFIG.lockTransform && !PermissionManager.canBypassTransformLock(serverPlayer)) {
                return false;
            }
            if (Remorphed.canUseEveryShape(player)) {
                return true;
            }
            return !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type));
        }
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(player, type) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(player, type));
    }

    public static List<ShapeType<?>> getUnlockedShapes(class_1657 player) {
        ArrayList unlocked = new ArrayList();
        for (ShapeType shapeType : ShapeType.getAllTypes((class_1937)player.method_37908())) {
            if (unlocked.contains(shapeType) || !Remorphed.canUseShape(player, shapeType)) continue;
            unlocked.add(shapeType);
        }
        return unlocked;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static List<GameProfile> getUnlockedSkins(class_1657 player) {
        int killRequirement = Remorphed.getPlayerKillRequirement(player);
        return new ArrayList<GameProfile>(PlayerMorph.getUnlockedSkinIds(player).keySet().stream().filter(skinId -> (PlayerMorph.getPlayerKills(player, skinId) >= killRequirement || killRequirement == 0) && killRequirement != -1).map(id -> SkinPlayerData.getSkinProfile((UUID)id).getNow(Optional.empty()).orElse(null)).filter(Objects::nonNull).toList());
    }

    public static int getKillToUnlock(class_1299<?> type) {
        return Remorphed.CONFIG.killToUnlockByType.getOrDefault(class_1299.method_5890(type).toString(), Remorphed.CONFIG.killToUnlock);
    }

    public static int getKillToUnlock(class_1657 player, class_1299<?> type) {
        return Remorphed.getKillToUnlock(type);
    }

    public static int getKillValue(class_1299<?> type) {
        return Remorphed.CONFIG.killValueByType.getOrDefault(class_1299.method_5890(type).toString(), Remorphed.CONFIG.killValue);
    }

    public static int getKillValue(class_1657 player, class_1299<?> type) {
        return Remorphed.getKillValue(type);
    }

    public static int getPlayerKillRequirement(class_1657 player) {
        return Remorphed.CONFIG.killToUnlockPlayers;
    }

    public static int getPlayerKillValue(class_1657 player) {
        return Remorphed.CONFIG.playerKillValue;
    }

    public static void sync(class_3222 player) {
        Remorphed.sync(player, player);
    }

    public static void sync(class_3222 changed, class_3222 packetTarget) {
        class_2487 compoundTag = new class_2487();
        Map<ShapeType<? extends class_1309>, Integer> unlockedShapes = PlayerMorph.getUnlockedShapes((class_1657)changed);
        class_2499 shapesList = new class_2499();
        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 compound = new class_2487();
                compound.method_10582("id", class_1299.method_5890((class_1299)shape.getEntityType()).toString());
                compound.method_10569("variant", shape.getVariantData());
                compound.method_10569("killAmount", killAmount.intValue());
                shapesList.add((Object)compound);
            }
        });
        if (!shapesList.isEmpty()) {
            compoundTag.method_10566("UnlockedShapes", (class_2520)shapesList);
        }
        Map<UUID, Integer> unlockedSkins = PlayerMorph.getUnlockedSkinIds((class_1657)changed);
        class_2499 skinsList = new class_2499();
        unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 compound = new class_2487();
                compound.method_10539("uuid", class_4844.method_26275((UUID)skinId));
                compound.method_10569("killAmount", killAmount.intValue());
                skinsList.add((Object)compound);
            }
        });
        if (!skinsList.isEmpty()) {
            compoundTag.method_10566("UnlockedSkins", (class_2520)skinsList);
        }
        class_2499 morphCounter = new class_2499();
        PlayerMorph.getShapeCounter((class_1657)changed).forEach((type, count) -> {
            if (count > 0 && type != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", false);
                entryTag.method_10582("id", class_1299.method_5890((class_1299)type.getEntityType()).toString());
                entryTag.method_10569("variant", type.getVariantData());
                entryTag.method_10569("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        PlayerMorph.getSkinCounter((class_1657)changed).forEach((skinId, count) -> {
            if (count > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", true);
                entryTag.method_10539("uuid", class_4844.method_26275((UUID)skinId));
                entryTag.method_10569("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        if (!morphCounter.isEmpty()) {
            compoundTag.method_10566("MorphCounter", (class_2520)morphCounter);
        }
        compoundTag.method_10539("uuid", class_4844.method_26275((UUID)changed.method_5667()));
        ModernNetworking.sendToPlayer((class_3222)packetTarget, (class_2960)NetworkHandler.UNLOCKED_SYNC, (class_2487)compoundTag);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MODID, (String)name);
    }
}

