/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.command.ListPermissionsCommand;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemorphedCommand
implements CommandEvents.CommandRegistration {
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 selection) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remorphed").requires(source -> source.method_9259(0))).build();
        rootNode.addChild(ListPermissionsCommand.createNode());
        LiteralCommandNode removeShape = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"removeShape").requires(source -> {
            if (source.method_9228() == null) {
                return source.method_9259(2);
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "removeShape") || PermissionManager.canUseCommandOnOthers(player, "removeShape");
            }
            return false;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)registry, (class_5321)class_7924.field_41266)).suggests(class_2321.method_71942((SuggestionProvider)class_2321.field_10935)).executes(context -> {
            RemorphedCommand.removeShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), null);
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            RemorphedCommand.removeShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode addShape = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"addShape").requires(source -> {
            if (source.method_9228() == null) {
                return source.method_9259(2);
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "addShape") || PermissionManager.canUseCommandOnOthers(player, "addShape");
            }
            return false;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)registry, (class_5321)class_7924.field_41266)).suggests(class_2321.method_71942((SuggestionProvider)class_2321.field_10935)).executes(context -> {
            RemorphedCommand.addShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), null);
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            RemorphedCommand.addShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode clearShapes = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clearShapes").requires(source -> {
            if (source.method_9228() == null) {
                return source.method_9259(2);
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "clearShapes") || PermissionManager.canUseCommandOnOthers(player, "clearShapes");
            }
            return false;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
            RemorphedCommand.clearShapes((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode hasShape = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hasShape").requires(source -> {
            if (source.method_9228() == null) {
                return source.method_9259(2);
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "hasShape") || PermissionManager.canUseCommandOnOthers(player, "hasShape");
            }
            return false;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)registry, (class_5321)class_7924.field_41266)).suggests(class_2321.method_71942((SuggestionProvider)class_2321.field_10935)).executes(context -> RemorphedCommand.hasShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), null))).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            return RemorphedCommand.hasShape((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), class_1299.method_5890((class_1299)((class_1299)class_7733.method_45610((CommandContext)context, (String)"shape").comp_349())), nbt);
        }))))).build();
        rootNode.addChild((CommandNode)removeShape);
        rootNode.addChild((CommandNode)addShape);
        rootNode.addChild((CommandNode)clearShapes);
        rootNode.addChild((CommandNode)hasShape);
        if (Remorphed.foundSkinShifter) {
            LiteralCommandNode removeSkin = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"removeSkin").requires(source -> {
                if (source.method_9228() == null) {
                    return source.method_9259(2);
                }
                class_1297 patt0$temp = source.method_9228();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.method_64475(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "removeSkin") || PermissionManager.canUseCommandOnOthers(player, "removeSkin");
                }
                return false;
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
                UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((UUID)playerUUID).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), true);
                    } else {
                        RemorphedCommand.removeSkin((class_2168)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
                String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((String)playerName).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
                    } else {
                        RemorphedCommand.removeSkin((class_2168)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            })))).build();
            LiteralCommandNode addSkin = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"addSkin").requires(source -> {
                if (source.method_9228() == null) {
                    return source.method_9259(2);
                }
                class_1297 patt0$temp = source.method_9228();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.method_64475(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "addSkin") || PermissionManager.canUseCommandOnOthers(player, "addSkin");
                }
                return false;
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
                UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((UUID)playerUUID).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), true);
                    } else {
                        RemorphedCommand.addSkin((class_2168)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
                String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((String)playerName).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
                    } else {
                        RemorphedCommand.addSkin((class_2168)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            })))).build();
            LiteralCommandNode clearSkins = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clearSkins").requires(source -> {
                if (source.method_9228() == null) {
                    return source.method_9259(2);
                }
                class_1297 patt0$temp = source.method_9228();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.method_64475(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "clearSkins") || PermissionManager.canUseCommandOnOthers(player, "clearSkins");
                }
                return false;
            })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> {
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                RemorphedCommand.clearSkins((class_2168)context.getSource(), player);
                return 1;
            }))).build();
            LiteralCommandNode hasSkin = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hasSkin").requires(source -> {
                if (source.method_9228() == null) {
                    return source.method_9259(2);
                }
                class_1297 patt0$temp = source.method_9228();
                if (patt0$temp instanceof class_3222) {
                    class_3222 player = (class_3222)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.method_64475(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "hasSkin") || PermissionManager.canUseCommandOnOthers(player, "hasSkin");
                }
                return false;
            })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"playerUUID", (ArgumentType)class_5242.method_27643()).executes(context -> {
                UUID playerUUID = class_5242.method_27645((CommandContext)context, (String)"playerUUID");
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((UUID)playerUUID).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), true);
                    } else {
                        RemorphedCommand.hasSkin((class_2168)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            }))).then(class_2170.method_9244((String)"playerName", (ArgumentType)class_2196.method_9340()).executes(context -> {
                String playerName = class_2196.method_9339((CommandContext)context, (String)"playerName").getString();
                class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
                CompletableFuture.runAsync(() -> {
                    GameProfile playerProfile = SkinPlayerData.getSkinProfile((String)playerName).getNow(Optional.empty()).orElse(null);
                    if (playerProfile == null) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
                    } else {
                        RemorphedCommand.hasSkin((class_2168)context.getSource(), player, playerProfile);
                    }
                });
                return 1;
            })))).build();
            rootNode.addChild((CommandNode)removeSkin);
            rootNode.addChild((CommandNode)addSkin);
            rootNode.addChild((CommandNode)clearSkins);
            rootNode.addChild((CommandNode)hasSkin);
        }
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int hasShape(@NotNull class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "hasShape")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return 0;
            }
        }
        ShapeType<class_1309> type = RemorphedCommand.getType(source.method_9225(), id, nbt);
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (PlayerMorph.getUnlockedShapes((class_1657)player).containsKey(type)) {
            source.method_9226(() -> RemorphedCommand.lambda$hasShape$35(player, (class_2561)name), true);
            return 1;
        }
        source.method_9226(() -> RemorphedCommand.lambda$hasShape$36(player, (class_2561)name), true);
        return 0;
    }

    private static void removeShape(@NotNull class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "removeShape")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        ShapeType<class_1309> type = RemorphedCommand.getType(source.method_9225(), id, nbt);
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        PlayerMorph.getUnlockedShapes((class_1657)player).remove(type);
        source.method_9226(() -> RemorphedCommand.lambda$removeShape$37((class_2561)name, player), true);
    }

    private static void addShape(@NotNull class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "addShape")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        ShapeType<class_1309> type = RemorphedCommand.getType(source.method_9225(), id, nbt);
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        PlayerMorph.getUnlockedShapes((class_1657)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        source.method_9226(() -> RemorphedCommand.lambda$addShape$38(player, (class_2561)name), true);
    }

    private static void clearShapes(@NotNull class_2168 source, class_3222 player) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "clearShapes")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedShapes((class_1657)player).clear();
        PlayerMorph.getShapeCounter((class_1657)player).clear();
        source.method_9226(() -> class_2561.method_43469((String)"remorphed.clearShapes", (Object[])new Object[]{player.method_5477()}), true);
        PlayerShapeChanger.change2ndShape((class_3222)player, null);
    }

    private static ShapeType<class_1309> getType(class_3218 serverLevel, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType type = ShapeType.from((class_1299)class_7923.field_41177.method_10223(id).map(class_6880::comp_349).orElse(null));
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_1297 loaded = class_1299.method_71371((class_2487)copy, (class_1937)serverLevel, (class_3730)class_3730.field_52444, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = new ShapeType(living);
            }
        }
        return type;
    }

    private static void hasSkin(class_2168 source, class_3222 player, @NotNull GameProfile playerProfile) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "hasSkin")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        if (PlayerMorph.getUnlockedSkinIds((class_1657)player).containsKey(playerProfile.getId())) {
            source.method_9226(() -> class_2561.method_43469((String)"remorphed.hasSkin_success", (Object[])new Object[]{player.method_5477(), playerProfile.getName()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"remorphed.hasSkin_fail", (Object[])new Object[]{player.method_5477(), playerProfile.getName()}), true);
        }
    }

    private static void removeSkin(@NotNull class_2168 source, class_3222 player, @NotNull GameProfile playerProfile) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "removeSkin")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedSkinIds((class_1657)player).remove(playerProfile.getId());
        source.method_9226(() -> class_2561.method_43469((String)"remorphed.removeSkin", (Object[])new Object[]{playerProfile.getName(), player.method_5477()}), true);
    }

    private static void addSkin(@NotNull class_2168 source, class_3222 player, @NotNull GameProfile playerProfile) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "addSkin")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedSkinIds((class_1657)player).put(playerProfile.getId(), Remorphed.CONFIG.killToUnlockPlayers);
        source.method_9226(() -> class_2561.method_43469((String)"remorphed.addSkin", (Object[])new Object[]{player.method_5477(), playerProfile.getName()}), true);
    }

    private static void clearSkins(@NotNull class_2168 source, class_3222 player) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 executor = (class_3222)class_12972;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "clearSkins")) {
                source.method_9213((class_2561)class_2561.method_43471((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedSkinIds((class_1657)player).clear();
        PlayerMorph.getSkinCounter((class_1657)player).clear();
        source.method_9226(() -> class_2561.method_43469((String)"remorphed.clearSkins", (Object[])new Object[]{player.method_5477()}), true);
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((class_3222)player, null);
        }
    }

    private static /* synthetic */ class_2561 lambda$addShape$38(class_3222 player, class_2561 name) {
        return class_2561.method_43469((String)"remorphed.addShape", (Object[])new Object[]{player.method_5477(), name});
    }

    private static /* synthetic */ class_2561 lambda$removeShape$37(class_2561 name, class_3222 player) {
        return class_2561.method_43469((String)"remorphed.removeShape", (Object[])new Object[]{name, player.method_5477()});
    }

    private static /* synthetic */ class_2561 lambda$hasShape$36(class_3222 player, class_2561 name) {
        return class_2561.method_43469((String)"remorphed.hasShape_fail", (Object[])new Object[]{player.method_5477(), name});
    }

    private static /* synthetic */ class_2561 lambda$hasShape$35(class_3222 player, class_2561 name) {
        return class_2561.method_43469((String)"remorphed.hasShape_success", (Object[])new Object[]{player.method_5477(), name});
    }
}

