/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.handler.client;

import com.mojang.authlib.GameProfile;
import dev.tocraft.craftedcore.event.client.ClientTickEvents;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.screen.EntityPreloadScreen;
import dev.tocraft.remorphed.screen.EntityRenderCache;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class EntityRenderCacheHandler
implements ClientTickEvents.Client {
    private boolean wasInWorld = false;
    private boolean hasPreloaded = false;
    private int ticksInWorld = 0;

    public void tick(class_310 client) {
        boolean isInWorld;
        boolean bl = isInWorld = client.field_1687 != null && client.field_1724 != null;
        if (!this.wasInWorld && isInWorld) {
            this.hasPreloaded = false;
            this.ticksInWorld = 0;
        }
        if (isInWorld && !this.hasPreloaded) {
            ++this.ticksInWorld;
            if (this.ticksInWorld >= 20) {
                this.hasPreloaded = true;
                this.preloadForPlayer(client.field_1724);
            }
        }
        this.wasInWorld = isInWorld;
    }

    private void preloadForPlayer(class_746 player) {
        if (player == null) {
            return;
        }
        try {
            EntityRenderCache.preloadEntities((class_1657)player);
            EntityRenderCache.preloadPlayerSkins((class_1657)player);
            this.startPreRendering(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startPreRendering(class_746 player) {
        List<ShapeType<?>> currentUnlockedShapes = Remorphed.getUnlockedShapes((class_1657)player);
        List<GameProfile> unlockedSkins = Remorphed.getUnlockedSkins((class_1657)player);
        ArrayList currentFilteredShapes = new ArrayList();
        HashSet<class_1299> seenTypes = new HashSet<class_1299>();
        for (ShapeType<?> shapeType : currentUnlockedShapes) {
            if (!seenTypes.add(shapeType.getEntityType())) continue;
            currentFilteredShapes.add(shapeType);
        }
        ArrayList<class_1308> entitiesToRender = new ArrayList<class_1308>();
        for (ShapeType shapeType : currentFilteredShapes) {
            class_1309 class_13092;
            EntityRenderCache.CachedEntityData cached = EntityRenderCache.getCachedEntity(shapeType);
            if (cached == null || !((class_13092 = cached.entity()) instanceof class_1308)) continue;
            class_1308 mob = (class_1308)class_13092;
            entitiesToRender.add(mob);
        }
        if (!entitiesToRender.isEmpty()) {
            class_310.method_1551().method_1507((class_437)new EntityPreloadScreen(entitiesToRender, unlockedSkins));
        }
    }
}

