/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.mixin;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements RemorphedPlayerDataProvider {
    @Unique
    private final Map<ShapeType<? extends class_1309>, Integer> remorphed$unlockedShapes = new HashMap<ShapeType<? extends class_1309>, Integer>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet();
    @Unique
    private final Map<UUID, Integer> remorphed$unlockedSkins = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private final Set<UUID> remorphed$favoriteSkins = new CopyOnWriteArraySet<UUID>();
    @Unique
    private final Map<ShapeType<?>, Integer> remorphed$ShapeMorphCounter = new ConcurrentHashMap();
    @Unique
    private final Map<UUID, Integer> remorphed$SkinMorphCounter = new ConcurrentHashMap<UUID, Integer>();
    @Unique
    private static final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private static final String FAVORITE_SHAPES = "FavoriteShapes";
    @Unique
    private static final String UNLOCKED_SKINS = "UnlockedSkins";
    @Unique
    private static final String FAVORITE_SKINS = "FavoriteSkins";
    @Unique
    private static final String MORPH_COUNTER = "MorphCounter";

    @Shadow
    public abstract boolean method_68878();

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        if (!this.method_37908().field_9236) {
            Remorphed.sync((class_3222)this);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(class_11368 in, CallbackInfo ci) {
        this.remorphed$readData(in.method_71426("remorphed", class_2487.field_25128).orElse(new class_2487()));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(class_11372 out, CallbackInfo ci) {
        out.method_71468("remorphed", class_2487.field_25128, (Object)this.remorphed$writeData());
    }

    @Unique
    @NotNull
    private class_2487 remorphed$writeData() {
        class_2487 tag = new class_2487();
        class_2499 unlockedShapes = new class_2499();
        this.remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", class_1299.method_5890((class_1299)shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                entryTag.method_10569("killAmount", killAmount.intValue());
                unlockedShapes.add((Object)entryTag);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            tag.method_10566(UNLOCKED_SHAPES, (class_2520)unlockedShapes);
        }
        class_2499 favoriteShapes = new class_2499();
        this.remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", class_1299.method_5890((class_1299)shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                favoriteShapes.add((Object)entryTag);
            }
        });
        if (!favoriteShapes.isEmpty()) {
            tag.method_10566(FAVORITE_SHAPES, (class_2520)favoriteShapes);
        }
        class_2499 unlockedSkins = new class_2499();
        this.remorphed$unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10539("uuid", class_4844.method_26275((UUID)skinId));
                entryTag.method_10569("killAmount", killAmount.intValue());
                unlockedSkins.add((Object)entryTag);
            }
        });
        if (!unlockedSkins.isEmpty()) {
            tag.method_10566(UNLOCKED_SKINS, (class_2520)unlockedSkins);
        }
        class_2499 favoriteSkins = new class_2499();
        this.remorphed$favoriteSkins.forEach(skinId -> {
            if (skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10539("uuid", class_4844.method_26275((UUID)skinId));
                favoriteSkins.add((Object)entryTag);
            }
        });
        if (!favoriteSkins.isEmpty()) {
            tag.method_10566(FAVORITE_SKINS, (class_2520)favoriteSkins);
        }
        class_2499 morphCounter = new class_2499();
        this.remorphed$ShapeMorphCounter.forEach((type, count) -> {
            if (count > 0 && type != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", false);
                entryTag.method_10582("id", class_1299.method_5890((class_1299)type.getEntityType()).toString());
                entryTag.method_10569("variant", type.getVariantData());
                entryTag.method_10569("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        this.remorphed$SkinMorphCounter.forEach((skinId, count) -> {
            if (count > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", true);
                entryTag.method_10539("uuid", class_4844.method_26275((UUID)skinId));
                entryTag.method_10569("counter", count.intValue());
                morphCounter.add((Object)entryTag);
            }
        });
        if (!morphCounter.isEmpty()) {
            tag.method_10566(MORPH_COUNTER, (class_2520)morphCounter);
        }
        return tag;
    }

    @Unique
    public void remorphed$readData(@NotNull class_2487 tag) {
        this.remorphed$unlockedShapes.clear();
        this.remorphed$favoriteShapes.clear();
        this.remorphed$unlockedSkins.clear();
        this.remorphed$favoriteSkins.clear();
        this.remorphed$SkinMorphCounter.clear();
        this.remorphed$ShapeMorphCounter.clear();
        class_2499 unlockedShapes = tag.method_68569(UNLOCKED_SHAPES);
        unlockedShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = class_2960.method_60654((String)((String)((class_2487)entry).method_10558("id").orElseThrow()));
                int typeVariantId = ((class_2487)entry).method_68083("variant", -1);
                int killAmount = ((class_2487)entry).method_68083("killAmount", 0);
                this.remorphed$unlockedShapes.put((ShapeType<? extends class_1309>)ShapeType.from((class_1299)class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), (int)typeVariantId), killAmount);
            }
        });
        class_2499 favoriteShapes = tag.method_68569(FAVORITE_SHAPES);
        favoriteShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = class_2960.method_60654((String)((String)((class_2487)entry).method_10558("id").orElseThrow()));
                int typeVariantId = ((class_2487)entry).method_68083("variant", -1);
                this.remorphed$favoriteShapes.add(ShapeType.from((class_1299)class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), (int)typeVariantId));
            }
        });
        class_2499 unlockedSkins = tag.method_68569(UNLOCKED_SKINS);
        unlockedSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = class_4844.method_26276((int[])((int[])((class_2487)entry).method_10561("uuid").orElseThrow()));
                int killAmount = ((class_2487)entry).method_68083("killAmount", 0);
                this.remorphed$unlockedSkins.put(skinId, killAmount);
            }
        });
        class_2499 favoriteSkins = tag.method_68569(FAVORITE_SKINS);
        favoriteSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = class_4844.method_26276((int[])((int[])((class_2487)entry).method_10561("uuid").orElseThrow()));
                this.remorphed$favoriteSkins.add(skinId);
            }
        });
        class_2499 morphCounter = tag.method_68569(MORPH_COUNTER);
        morphCounter.forEach(entry -> {
            boolean isSkin = (Boolean)((class_2487)entry).method_10577("isSkin").orElseThrow();
            int count = ((class_2487)entry).method_68083("counter", 0);
            if (isSkin) {
                UUID skinId = class_4844.method_26276((int[])((int[])((class_2487)entry).method_10561("uuid").orElseThrow()));
                this.remorphed$SkinMorphCounter.put(skinId, count);
            } else {
                class_2960 typeId = class_2960.method_60654((String)((String)((class_2487)entry).method_10558("id").orElseThrow()));
                int typeVariantId = ((class_2487)entry).method_68083("variant", -1);
                this.remorphed$ShapeMorphCounter.put(ShapeType.from((class_1299)class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), (int)typeVariantId), count);
            }
        });
    }

    @Override
    @Unique
    public Map<ShapeType<? extends class_1309>, Integer> remorphed$getUnlockedShapes() {
        return this.remorphed$unlockedShapes;
    }

    @Override
    @Unique
    public void remorphed$addKill(ShapeType<? extends class_1309> type) {
        this.remorphed$unlockedShapes.put(type, this.remorphed$getKills(type) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(ShapeType<? extends class_1309> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (int i : this.remorphed$unlockedShapes.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i;
            }
            return killAmount;
        }
        return this.remorphed$unlockedShapes.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public Set<ShapeType<?>> remorphed$getFavoriteShapes() {
        return this.remorphed$favoriteShapes;
    }

    @Override
    @Unique
    public Map<UUID, Integer> remorphed$getUnlockedSkins() {
        return this.remorphed$unlockedSkins;
    }

    @Override
    @Unique
    public void remorphed$addKill(UUID skinId) {
        this.remorphed$unlockedSkins.put(skinId, this.remorphed$getKills(skinId) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(UUID skinId) {
        return this.remorphed$unlockedSkins.getOrDefault(skinId, 0);
    }

    @Override
    @Unique
    public Set<UUID> remorphed$getFavoriteSkins() {
        return this.remorphed$favoriteSkins;
    }

    @Override
    @Unique
    public int remorphed$getCounter(ShapeType<? extends class_1309> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int counter = 0;
            for (int i : this.remorphed$ShapeMorphCounter.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                counter += i;
            }
            return counter;
        }
        return this.remorphed$ShapeMorphCounter.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public int remorphed$getCounter(UUID skinId) {
        return this.remorphed$SkinMorphCounter.getOrDefault(skinId, 0);
    }

    @Override
    @Unique
    public void remorphed$handleSwap(ShapeType<? extends class_1309> type) {
        if (((class_1657)this).method_68878()) {
            return;
        }
        int counter = this.remorphed$getCounter(type) + 1;
        int killValue = Remorphed.getKillValue(type.getEntityType());
        if (killValue > 0 && counter >= killValue) {
            class_3222 serverPlayer;
            int k = this.remorphed$unlockedShapes.getOrDefault(type, 0);
            ShapeType killType = type;
            if (Walkers.CONFIG.unlockEveryVariant) {
                List variants = ShapeType.getAllTypes((class_1299)type.getEntityType(), (class_1937)this.method_37908());
                for (int i = 0; k <= 0 && i < variants.size(); ++i) {
                    killType = (ShapeType)variants.get(i);
                    k = this.remorphed$unlockedShapes.getOrDefault(killType, 0);
                }
            }
            if (k <= 1) {
                int variants = this.remorphed$unlockedShapes.containsKey(killType) ? this.remorphed$unlockedShapes.remove(killType) : 0;
            } else {
                this.remorphed$unlockedShapes.put(killType, k - 1);
            }
            if (Walkers.CONFIG.unlockEveryVariant) {
                List variants = ShapeType.getAllTypes((class_1299)type.getEntityType(), (class_1937)this.method_37908());
                for (int i = 0; counter > 0 && i < variants.size(); ++i) {
                    Integer c = this.remorphed$ShapeMorphCounter.remove(variants.get(i));
                    if (c == null) continue;
                    counter -= c.intValue();
                }
            } else {
                this.remorphed$ShapeMorphCounter.remove(type);
            }
            PlayerEntityMixin playerEntityMixin = this;
            if (playerEntityMixin instanceof class_3222 && !Remorphed.canUseShape((class_1657)(serverPlayer = (class_3222)playerEntityMixin), type)) {
                PlayerShapeChanger.change2ndShape((class_3222)serverPlayer, null);
            }
        } else {
            this.remorphed$ShapeMorphCounter.put(type, this.remorphed$ShapeMorphCounter.getOrDefault(type, 0) + 1);
        }
    }

    @Override
    @Unique
    public void remorphed$handleSwap(UUID skinId) {
        if (((class_1657)this).method_68878()) {
            return;
        }
        int counter = this.remorphed$SkinMorphCounter.getOrDefault(skinId, 0) + 1;
        int killValue = Remorphed.CONFIG.playerKillValue;
        if (killValue > 0 && ++counter >= killValue) {
            this.remorphed$SkinMorphCounter.remove(skinId);
            int k = this.remorphed$getKills(skinId) - 1;
            if (k <= 0) {
                this.remorphed$unlockedSkins.remove(skinId);
            } else {
                this.remorphed$unlockedSkins.put(skinId, k);
            }
        } else {
            this.remorphed$SkinMorphCounter.put(skinId, counter);
        }
    }

    @Override
    @Unique
    public Map<ShapeType<?>, Integer> remorphed$getShapeCounter() {
        return this.remorphed$ShapeMorphCounter;
    }

    @Override
    @Unique
    public Map<UUID, Integer> remorphed$getSkinCounter() {
        return this.remorphed$SkinMorphCounter;
    }
}

