/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.network;

import dev.tocraft.craftedcore.client.CraftedCoreClient;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.craftedcore.network.client.ClientNetworking;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.network.PermissionCheckPacket;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.UNLOCKED_SYNC, ClientNetworking::handleUnlockedSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.PERMISSION_RESPONSE, PermissionCheckPacket::handlePermissionResponse);
    }

    public static void handleUnlockedSyncPacket(ModernNetworking.Context context, @NotNull class_2487 compound) {
        UUID uuid = class_4844.method_26276((int[])((int[])compound.method_10561("uuid").orElseThrow()));
        HashMap unlockedShapes = new HashMap();
        if (compound.method_10545("UnlockedShapes")) {
            compound.method_68569("UnlockedShapes").forEach(entryTag -> {
                class_1299 eType = class_7923.field_41177.method_10223(class_2960.method_60654((String)((String)((class_2487)entryTag).method_10558("id").orElseThrow()))).map(class_6880::comp_349).orElse(null);
                int variant = ((class_2487)entryTag).method_68083("variant", -1);
                int killAmount = ((class_2487)entryTag).method_68083("killAmount", 0);
                unlockedShapes.put(ShapeType.from((class_1299)eType, (int)variant), killAmount);
            });
        }
        HashMap unlockedSkins = new HashMap();
        if (compound.method_10545("UnlockedSkins")) {
            compound.method_68569("UnlockedSkins").forEach(entryTag -> {
                UUID unlockedSkinUUID = class_4844.method_26276((int[])((int[])((class_2487)entryTag).method_10561("uuid").orElseThrow()));
                int killAmount = ((class_2487)entryTag).method_68083("killAmount", 0);
                unlockedSkins.put(unlockedSkinUUID, killAmount);
            });
        }
        HashMap shapeCounter = new HashMap();
        HashMap skinCounter = new HashMap();
        if (compound.method_10545("MorphCounter")) {
            compound.method_68569("MorphCounter").forEach(entry -> {
                boolean isSkin = (Boolean)((class_2487)entry).method_10577("isSkin").orElseThrow();
                int count = ((class_2487)entry).method_68083("counter", 0);
                if (isSkin) {
                    UUID skinId = class_4844.method_26276((int[])((int[])((class_2487)entry).method_10561("uuid").orElseThrow()));
                    skinCounter.put(skinId, count);
                } else {
                    class_2960 typeId = class_2960.method_60654((String)((String)((class_2487)entry).method_10558("id").orElseThrow()));
                    int typeVariantId = ((class_2487)entry).method_68083("variant", -1);
                    shapeCounter.put(ShapeType.from((class_1299)class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), (int)typeVariantId), count);
                }
            });
        }
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_37908().method_18470(uuid);
            if (syncTarget != null) {
                PlayerMorph.getUnlockedShapes(player).clear();
                PlayerMorph.getUnlockedShapes(player).putAll(unlockedShapes);
                PlayerMorph.getUnlockedSkinIds(player).clear();
                PlayerMorph.getUnlockedSkinIds(player).putAll(unlockedSkins);
                PlayerMorph.getShapeCounter(player).clear();
                PlayerMorph.getShapeCounter(player).putAll(shapeCounter);
                PlayerMorph.getSkinCounter(player).clear();
                PlayerMorph.getSkinCounter(player).putAll(skinCounter);
            }
        });
    }

    private static void handleFavoriteSyncPacket(ModernNetworking.Context context, class_2487 tag) {
        ClientNetworking.runOrQueue(context, player -> {
            PlayerMorph.getFavoriteShapes(player).clear();
            PlayerMorph.getFavoriteSkinIds(player).clear();
            class_2499 shapeIds = tag.method_68569("FavoriteShapes");
            class_2499 skinIds = tag.method_68569("FavoriteSkins");
            shapeIds.forEach(compound -> PlayerMorph.getFavoriteShapes(player).add(ShapeType.from((class_2487)((class_2487)compound))));
            skinIds.forEach(skinId -> PlayerMorph.getFavoriteSkinIds(player).add(class_4844.method_26276((int[])((int[])skinId.method_68572().orElseThrow()))));
        });
    }

    public static void runOrQueue(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}

