/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.network;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ClientPermissionCache {
    private static final ConcurrentMap<String, Boolean> permissionCache = new ConcurrentHashMap<String, Boolean>();

    public static void setPermission(String permission, boolean hasPermission) {
        permissionCache.put(permission, hasPermission);
    }

    public static Boolean getPermission(String permission) {
        return (Boolean)permissionCache.get(permission);
    }

    public static boolean hasPermission(String permission) {
        return permissionCache.containsKey(permission);
    }

    public static void clearCache() {
        permissionCache.clear();
    }

    public static void removePermission(String permission) {
        permissionCache.remove(permission);
    }
}

