/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.network;

import com.mojang.authlib.GameProfile;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetworkHandler {
    public static final class_2960 MORPH_REQUEST = Remorphed.id("morph_request");
    public static final class_2960 UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final class_2960 FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final class_2960 FAVORITE_UPDATE = Remorphed.id("favorite_update");
    public static final class_2960 RESET_SKIN = Remorphed.id("reset_skin");
    public static final class_2960 PERMISSION_CHECK = Remorphed.id("permission_check");
    public static final class_2960 PERMISSION_RESPONSE = Remorphed.id("permission_response");
    public static final class_2960 DELETE_SHAPE = Remorphed.id("delete_shape");

    public static void registerPacketReceiver() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)MORPH_REQUEST, NetworkHandler::handleMorphRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)RESET_SKIN, NetworkHandler::handleResetSkinPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)PERMISSION_CHECK, NetworkHandler::handlePermissionCheckPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (class_2960)DELETE_SHAPE, NetworkHandler::handleDeleteShapePacket);
        ModernNetworking.registerType((class_2960)UNLOCKED_SYNC);
        ModernNetworking.registerType((class_2960)FAVORITE_SYNC);
        ModernNetworking.registerType((class_2960)PERMISSION_RESPONSE);
    }

    private static void handleDeleteShapePacket(ModernNetworking.Context context, class_2487 data) {
        boolean is_entity = data.method_10577("is_entity").orElse(true);
        if (is_entity) {
            String id = (String)data.method_10558("id").orElseThrow();
            int v = data.method_68083("variant", -1);
            class_1299 type = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)id));
            PlayerMorph.handleSwap(context.getPlayer(), (ShapeType<? extends class_1309>)ShapeType.from((class_1299)type, (int)v));
        } else {
            String uuid = (String)data.method_10558("uuid").orElseThrow();
            PlayerMorph.handleSwap(context.getPlayer(), UUID.fromString(uuid));
        }
    }

    public static void sendDeleteShapePacket(ShapeType<?> type) {
        class_2487 compound = new class_2487();
        compound.method_10556("is_entity", true);
        compound.method_10582("id", class_1299.method_5890((class_1299)type.getEntityType()).toString());
        compound.method_10569("variant", type.getVariantData());
        ModernNetworking.sendToServer((class_2960)DELETE_SHAPE, (class_2487)compound);
    }

    public static void sendDeleteShapePacket(UUID uuid) {
        class_2487 compound = new class_2487();
        compound.method_10556("is_entity", true);
        compound.method_10582("uuid", uuid.toString());
        ModernNetworking.sendToServer((class_2960)DELETE_SHAPE, (class_2487)compound);
    }

    private static void handleResetSkinPacket(ModernNetworking.Context context, class_2487 data) {
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((class_3222)((class_3222)context.getPlayer()), null);
        }
    }

    private static void handlePermissionCheckPacket(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModernNetworking.Context context, @NotNull class_2487 tag) {
        class_3222 player = (class_3222)context.getPlayer();
        String permission = tag.method_10558("permission").orElse("");
        boolean hasPermission = !Remorphed.CONFIG.usePermissions || PermissionManager.hasPermission(player, permission);
        class_2487 response = new class_2487();
        response.method_10582("permission", permission);
        response.method_10556("hasPermission", hasPermission);
        ModernNetworking.sendToPlayer((class_3222)player, (class_2960)PERMISSION_RESPONSE, (class_2487)response);
    }

    public static void sendResetSkinPacket() {
        ModernNetworking.sendToServer((class_2960)RESET_SKIN, (class_2487)new class_2487());
    }

    public static <T extends class_1309> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        class_2487 compound = new class_2487();
        compound.method_10582("id", class_1299.method_5890((class_1299)type.getEntityType()).toString());
        compound.method_10569("variant", type.getVariantData());
        ModernNetworking.sendToServer((class_2960)MORPH_REQUEST, (class_2487)compound);
    }

    public static <T extends class_1309> void sendSwapSkinRequest(@NotNull GameProfile playerProfile) {
        class_2487 compound = new class_2487();
        compound.method_10539("playerUUID", class_4844.method_26275((UUID)playerProfile.getId()));
        ModernNetworking.sendToServer((class_2960)MORPH_REQUEST, (class_2487)compound);
    }

    private static void handleMorphRequestPacket(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModernNetworking.Context context, class_2487 compound) {
        context.getPlayer().method_5682().execute(() -> {
            if (Walkers.isPlayerBlacklisted((UUID)context.getPlayer().method_5667()) && Walkers.CONFIG.blacklistPreventsMorphing) {
                context.getPlayer().method_7353((class_2561)class_2561.method_43471((String)"walkers.player_blacklisted"), true);
                return;
            }
            if (compound.method_10545("playerUUID") && Remorphed.foundSkinShifter) {
                UUID targetSkinUUID = class_4844.method_26276((int[])((int[])compound.method_10561("playerUUID").orElseThrow()));
                SkinShifter.setSkin((class_3222)((class_3222)context.getPlayer()), (UUID)targetSkinUUID);
                PlayerMorph.handleSwap(context.getPlayer(), targetSkinUUID);
            } else {
                class_2960 typeId = class_2960.method_60654((String)((String)compound.method_10558("id").orElseThrow()));
                int typeVariant = compound.method_68083("variant", -1);
                class_1299 eType = class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null);
                @Nullable ShapeType type = ShapeType.from((class_1299)eType, (int)typeVariant);
                boolean result = PlayerShapeChanger.change2ndShape((class_3222)((class_3222)context.getPlayer()), (ShapeType)type);
                if (result && type != null) {
                    PlayerShape.updateShapes((class_3222)((class_3222)context.getPlayer()), (class_1309)type.create(context.getPlayer().method_37908(), context.getPlayer()));
                }
                context.getPlayer().method_18382();
            }
        });
    }

    public static void sendFavoriteSync(class_3222 player) {
        Set<ShapeType<?>> favoriteShapes = PlayerMorph.getFavoriteShapes((class_1657)player);
        Set<UUID> favoriteSkins = PlayerMorph.getFavoriteSkinIds((class_1657)player);
        class_2487 tag = new class_2487();
        class_2499 shapeIdList = new class_2499();
        class_2499 skinIdList = new class_2499();
        favoriteShapes.forEach(type -> shapeIdList.add((Object)type.writeCompound()));
        favoriteSkins.forEach(skin -> skinIdList.add((Object)new class_2495(class_4844.method_26275((UUID)skin))));
        tag.method_10566("FavoriteShapes", (class_2520)shapeIdList);
        tag.method_10566("FavoriteSkins", (class_2520)skinIdList);
        ModernNetworking.sendToPlayer((class_3222)player, (class_2960)FAVORITE_SYNC, (class_2487)tag);
    }

    public static void sendFavoriteRequest(@NotNull ShapeType<? extends class_1309> type, boolean favorite) {
        class_2487 packet = new class_2487();
        packet.method_10582("id", class_1299.method_5890((class_1299)type.getEntityType()).toString());
        packet.method_10569("variant", type.getVariantData());
        packet.method_10556("favorite", favorite);
        ModernNetworking.sendToServer((class_2960)FAVORITE_UPDATE, (class_2487)packet);
    }

    public static void sendFavoriteRequest(@NotNull GameProfile playerProfile, boolean favorite) {
        class_2487 packet = new class_2487();
        packet.method_10539("playerUUID", class_4844.method_26275((UUID)playerProfile.getId()));
        packet.method_10556("favorite", favorite);
        ModernNetworking.sendToServer((class_2960)FAVORITE_UPDATE, (class_2487)packet);
    }

    private static void handleFavoriteRequestPacket(ModernNetworking.Context context, @NotNull class_2487 packet) {
        boolean favorite = packet.method_68566("favorite", false);
        if (packet.method_10545("playerUUID")) {
            UUID skinId = class_4844.method_26276((int[])((int[])packet.method_10561("playerUUID").orElseThrow()));
            context.getPlayer().method_5682().execute(() -> {
                if (favorite) {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).add(skinId);
                } else {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).remove(skinId);
                }
                NetworkHandler.sendFavoriteSync((class_3222)context.getPlayer());
            });
        } else {
            class_1299 entityType = class_7923.field_41177.method_10223(class_2960.method_60654((String)((String)packet.method_10558("id").orElseThrow()))).map(class_6880::comp_349).orElse(null);
            int variant = packet.method_68083("variant", -1);
            context.getPlayer().method_5682().execute(() -> {
                @Nullable ShapeType type = ShapeType.from((class_1299)entityType, (int)variant);
                if (type != null) {
                    if (favorite) {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).add(type);
                    } else {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).remove(type);
                    }
                    NetworkHandler.sendFavoriteSync((class_3222)context.getPlayer());
                }
            });
        }
    }
}

