/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen;

import com.mojang.authlib.GameProfile;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.FakeClientPlayer;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1589;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EntityRenderCache {
    private static final Map<ShapeType<?>, CachedEntityData> ENTITY_CACHE = new ConcurrentHashMap();
    private static final Map<GameProfile, CachedEntityData> PLAYER_CACHE = new ConcurrentHashMap<GameProfile, CachedEntityData>();

    public static void preloadEntities(class_1657 player) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        List allShapes = ShapeType.getAllTypes((class_1937)player.method_37908());
        for (ShapeType type : allShapes) {
            if (ENTITY_CACHE.containsKey(type)) continue;
            try {
                class_1309 entity = type.create((class_1937)minecraft.field_1687, player);
                if (!(entity instanceof class_1308)) continue;
                class_1308 mob = (class_1308)entity;
                EntityRenderCache.prepareStaticEntity(mob);
                ENTITY_CACHE.putIfAbsent(type, new CachedEntityData((class_1309)mob));
            }
            catch (Exception e) {
                Remorphed.LOGGER.warn("[Remorphed] Failed to pre-load entity for type {}: {}", (Object)type.getEntityType().method_5882(), (Object)e.getMessage());
            }
        }
    }

    public static void preloadPlayerSkins(class_1657 player) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        List<GameProfile> unlockedSkins = Remorphed.getUnlockedSkins(player);
        for (GameProfile profile : unlockedSkins) {
            if (profile.getId().equals(player.method_5667()) || PLAYER_CACHE.containsKey(profile)) continue;
            try {
                FakeClientPlayer fakePlayer = new FakeClientPlayer(minecraft.field_1687, profile);
                fakePlayer.method_5684(true);
                PLAYER_CACHE.putIfAbsent(profile, new CachedEntityData((class_1309)fakePlayer));
            }
            catch (Exception e) {
                Remorphed.LOGGER.warn("[Remorphed] Failed to pre-load player skin for profile {}: {}", (Object)profile.getName(), (Object)e.getMessage());
            }
        }
    }

    private static void prepareStaticEntity(class_1308 mob) {
        mob.method_5977(true);
        mob.method_5684(true);
        if (mob instanceof class_1621) {
            class_1621 slime = (class_1621)mob;
            slime.method_7161(1, true);
        } else if (mob instanceof class_1589) {
            class_1589 magmaCube = (class_1589)mob;
            magmaCube.method_7161(1, true);
        }
        mob.method_5834(true);
    }

    @Nullable
    public static CachedEntityData getCachedEntity(ShapeType<?> type) {
        return ENTITY_CACHE.get(type);
    }

    @Nullable
    public static CachedEntityData getCachedPlayerSkin(GameProfile profile) {
        return PLAYER_CACHE.get(profile);
    }

    public static void cacheEntity(ShapeType<?> type, class_1657 player) {
        if (ENTITY_CACHE.containsKey(type)) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        try {
            class_1309 entity = type.create((class_1937)minecraft.field_1687, player);
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                EntityRenderCache.prepareStaticEntity(mob);
                ENTITY_CACHE.putIfAbsent(type, new CachedEntityData((class_1309)mob));
            }
        }
        catch (Exception e) {
            Remorphed.LOGGER.warn("[Remorphed] Failed to cache entity on-demand: {}", (Object)type.getEntityType().method_5882(), (Object)e);
        }
    }

    public static void cachePlayerSkin(GameProfile profile) {
        if (PLAYER_CACHE.containsKey(profile)) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        try {
            FakeClientPlayer fakePlayer = new FakeClientPlayer(minecraft.field_1687, profile);
            fakePlayer.method_5684(true);
            PLAYER_CACHE.putIfAbsent(profile, new CachedEntityData((class_1309)fakePlayer));
        }
        catch (Exception e) {
            Remorphed.LOGGER.warn("[Remorphed] Failed to cache player skin on-demand: {}", (Object)profile.getName(), (Object)e);
        }
    }

    public static void clearCache() {
        ENTITY_CACHE.clear();
        PLAYER_CACHE.clear();
    }

    public static int getCachedEntityCount() {
        return ENTITY_CACHE.size();
    }

    public static int getCachedPlayerSkinCount() {
        return PLAYER_CACHE.size();
    }

    public record CachedEntityData(class_1309 entity) {
    }
}

