/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen;

import com.mojang.authlib.GameProfile;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.FakeClientPlayer;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.mixin.client.accessor.ScreenAccessor;
import dev.tocraft.remorphed.screen.EntityRenderCache;
import dev.tocraft.remorphed.screen.RemorphedHelpScreen;
import dev.tocraft.remorphed.screen.widget.EntityWidget;
import dev.tocraft.remorphed.screen.widget.PlayerWidget;
import dev.tocraft.remorphed.screen.widget.SearchWidget;
import dev.tocraft.remorphed.screen.widget.ShapeListWidget;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import dev.tocraft.remorphed.screen.widget.SkinWidget;
import dev.tocraft.remorphed.screen.widget.SpecialShapeWidget;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class RemorphedMenu
extends class_437 {
    @Nullable
    protected ShapeListWidget list;
    public final class_8132 layout = new class_8132((class_437)this);
    private static String lastSearchContents = "";
    private final List<ShapeType<?>> unlockedShapes = new CopyOnWriteArrayList();
    private final List<GameProfile> unlockedSkins = new CopyOnWriteArrayList<GameProfile>();
    private final Map<ShapeType<?>, class_1308> renderEntities = new ConcurrentHashMap();
    private final Map<GameProfile, FakeClientPlayer> renderPlayers = new ConcurrentHashMap<GameProfile, FakeClientPlayer>();
    private final SearchWidget searchBar = this.createSearchBar();
    private final class_4185 helpButton = this.createHelpButton();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = this.createSpecialShapeButton();
    private final class_4185 traitsButton = this.createTraitsButton();

    public RemorphedMenu() {
        super((class_2561)class_2561.method_43470((String)"ReMorphed Menu"));
    }

    protected void method_25426() {
        this.addHeader();
        this.addContents();
        this.addFooter();
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_48640();
    }

    protected void addHeader() {
        class_8667 linearLayout = ((class_8667)this.layout.method_48992((class_8021)class_8667.method_52742())).method_52735(8);
        linearLayout.method_52736((class_8021)this.traitsButton);
        linearLayout.method_52736((class_8021)this.searchBar);
        linearLayout.method_52736((class_8021)this.helpButton);
        linearLayout.method_52736((class_8021)this.playerButton);
        if (this.field_22787 != null && this.field_22787.field_1724 != null && Walkers.hasSpecialShape((UUID)this.field_22787.field_1724.method_5667())) {
            linearLayout.method_52736((class_8021)this.specialShapeButton);
        }
    }

    protected void addContents() {
        this.list = (ShapeListWidget)this.layout.method_48999((class_8021)new ShapeListWidget(this.field_22787, this.field_22789, this.layout));
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.populateUnlockedRenderEntities((class_1657)this.field_22787.field_1724);
            ShapeType currentShape = ShapeType.from((class_1309)PlayerShape.getCurrentShape((class_1657)this.field_22787.field_1724));
            this.unlockedShapes.sort((first, second) -> {
                boolean secondIsFav;
                boolean firstIsFav;
                if (Remorphed.CONFIG.sort_selected) {
                    if (Objects.equals(first, currentShape)) {
                        return -1;
                    }
                    if (Objects.equals(second, currentShape)) {
                        return 1;
                    }
                }
                if ((firstIsFav = PlayerMorph.getFavoriteShapes((class_1657)this.field_22787.field_1724).contains(first)) == (secondIsFav = PlayerMorph.getFavoriteShapes((class_1657)this.field_22787.field_1724).contains(second))) {
                    return 0;
                }
                if (firstIsFav) {
                    return -1;
                }
                return 1;
            });
            ArrayList newUnlocked = new ArrayList();
            HashSet<class_1299> seenTypes = new HashSet<class_1299>();
            for (ShapeType<?> shapeType : this.unlockedShapes) {
                if (seenTypes.contains(shapeType.getEntityType()) || currentShape != null && !shapeType.equals((Object)currentShape) && shapeType.getEntityType() == currentShape.getEntityType() && shapeType.getVariantData() != currentShape.getVariantData()) continue;
                newUnlocked.add(shapeType);
                seenTypes.add(shapeType.getEntityType());
            }
            this.unlockedShapes.clear();
            this.unlockedShapes.addAll(newUnlocked);
            if (Remorphed.foundSkinShifter) {
                this.populateUnlockedRenderPlayers((class_1657)this.field_22787.field_1724);
                UUID currentSkin = SkinShifter.getCurrentSkin((class_1657)this.field_22787.field_1724);
                this.unlockedSkins.sort((first, second) -> {
                    boolean secondIsFav;
                    if (Objects.equals(first.getId(), currentSkin) && currentShape != null) {
                        return -1;
                    }
                    if (Objects.equals(second.getId(), currentSkin) && currentShape != null) {
                        return 1;
                    }
                    boolean firstIsFav = PlayerMorph.getFavoriteSkinIds((class_1657)this.field_22787.field_1724).contains(first.getId());
                    if (firstIsFav == (secondIsFav = PlayerMorph.getFavoriteSkinIds((class_1657)this.field_22787.field_1724).contains(second.getId()))) {
                        return first.getName().compareTo(second.getName());
                    }
                    if (firstIsFav) {
                        return -1;
                    }
                    return 1;
                });
            }
        }
        this.searchBar.method_1863(text -> {
            ((ScreenAccessor)((Object)this)).getNarratables().removeIf(button -> button instanceof EntityWidget);
            this.method_25396().removeIf(button -> button instanceof EntityWidget);
            List<ShapeType<?>> filteredShapes = this.unlockedShapes.stream().filter(type -> text.isEmpty() || ShapeType.createTooltipText((class_1309)this.renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || class_1299.method_5890((class_1299)type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase())).toList();
            List<GameProfile> filteredSkins = this.unlockedSkins.stream().filter(skin -> text.isEmpty() || skin.getName().toUpperCase().contains(text.toUpperCase()) || skin.getId().toString().contains(text.toUpperCase())).toList();
            this.populateShapeWidgets(filteredShapes, filteredSkins);
            lastSearchContents = text;
        });
        this.searchBar.method_1867(lastSearchContents);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void populateShapeWidgets(@NotNull List<ShapeType<?>> rendered, @NotNull List<GameProfile> skinProfiles) {
        if (this.list != null && this.field_22787 != null && this.field_22787.field_1724 != null) {
            this.list.method_25339();
            int rows = (int)Math.ceil((float)(rendered.size() + skinProfiles.size()) / (float)Remorphed.CONFIG.shapes_per_row);
            ShapeType currentType = ShapeType.from((class_1309)PlayerShape.getCurrentShape((class_1657)this.field_22787.field_1724));
            int currentRow = 0;
            for (int i = 0; i <= rows; ++i) {
                ArrayList<ShapeWidget> row = new ArrayList<ShapeWidget>();
                for (int j = 0; j < Remorphed.CONFIG.shapes_per_row; ++j) {
                    boolean bl;
                    int listIndex = i * Remorphed.CONFIG.shapes_per_row + j;
                    if (Remorphed.foundSkinShifter && listIndex < skinProfiles.size()) {
                        GameProfile skinProfile = skinProfiles.get(listIndex);
                        class_742 fakePlayer = this.renderPlayers.get(skinProfile);
                        if (fakePlayer != null) {
                            boolean bl2 = bl = Objects.equals(SkinShifter.getCurrentSkin((class_1657)this.field_22787.field_1724), skinProfile.getId()) && currentType == null;
                            if (bl) {
                                currentRow = i;
                            }
                            row.add(new SkinWidget(0, 0, 0, 0, skinProfile, (FakeClientPlayer)fakePlayer, this, PlayerMorph.getFavoriteSkins((class_1657)this.field_22787.field_1724).contains(skinProfile), bl, Remorphed.canUseEveryShape((class_1657)this.field_22787.field_1724) || Remorphed.CONFIG.playerKillValue < 1 ? -1 : Remorphed.CONFIG.playerKillValue * PlayerMorph.getPlayerKills((class_1657)this.field_22787.field_1724, skinProfile.getId()) - PlayerMorph.getCounter((class_1657)this.field_22787.field_1724, skinProfile.getId())));
                            continue;
                        }
                        Remorphed.LOGGER.error("invalid skin profile: {}", (Object)skinProfile);
                        continue;
                    }
                    if (listIndex >= skinProfiles.size() + rendered.size()) continue;
                    ShapeType<?> type = rendered.get(listIndex - skinProfiles.size());
                    class_1308 entity = this.renderEntities.get(type);
                    if (entity != null) {
                        bl = type.equals((Object)currentType);
                        if (bl) {
                            currentRow = i;
                        }
                        row.add(new EntityWidget<class_1308>(i * Remorphed.CONFIG.shapes_per_row + j, 0, 0, 0, 0, type, entity, this, PlayerMorph.getFavoriteShapes((class_1657)this.field_22787.field_1724).contains(type), bl, Remorphed.canUseEveryShape((class_1657)this.field_22787.field_1724) || Remorphed.getKillValue(type.getEntityType()) < 1 ? -1 : Remorphed.getKillValue(type.getEntityType()) * PlayerMorph.getKills((class_1657)this.field_22787.field_1724, type) - PlayerMorph.getCounter((class_1657)this.field_22787.field_1724, type)));
                        continue;
                    }
                    Remorphed.LOGGER.error("invalid shape type: {}", (Object)type.getEntityType().method_5882());
                }
                this.list.addRow((ShapeWidget[])row.toArray(ShapeWidget[]::new));
            }
            if (Remorphed.CONFIG.focus_selected) {
                this.list.method_44382((double)this.list.rowHeight() * (double)(currentRow - 2));
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(class_1657 player) {
        this.unlockedShapes.clear();
        this.renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            class_1309 class_13092;
            class_1309 class_13093;
            EntityRenderCache.CachedEntityData cachedData = EntityRenderCache.getCachedEntity(type);
            if (cachedData != null && (class_13093 = cachedData.entity()) instanceof class_1308) {
                class_1308 cachedMob = (class_1308)class_13093;
                this.renderEntities.put(type, cachedMob);
                this.unlockedShapes.add(type);
                continue;
            }
            EntityRenderCache.cacheEntity(type, player);
            cachedData = EntityRenderCache.getCachedEntity(type);
            if (cachedData == null || !((class_13092 = cachedData.entity()) instanceof class_1308)) continue;
            class_1308 cachedMob = (class_1308)class_13092;
            this.renderEntities.put(type, cachedMob);
            this.unlockedShapes.add(type);
        }
    }

    public synchronized void populateUnlockedRenderPlayers(class_1657 player) {
        this.unlockedSkins.clear();
        this.renderPlayers.clear();
        List<GameProfile> validUnlocked = Remorphed.getUnlockedSkins(player);
        for (GameProfile profile : validUnlocked) {
            class_1309 class_13092;
            class_1309 class_13093;
            if (profile.getId() == player.method_5667()) continue;
            EntityRenderCache.CachedEntityData cachedData = EntityRenderCache.getCachedPlayerSkin(profile);
            if (cachedData != null && (class_13093 = cachedData.entity()) instanceof FakeClientPlayer) {
                FakeClientPlayer cachedPlayer = (FakeClientPlayer)class_13093;
                this.renderPlayers.put(profile, cachedPlayer);
                this.unlockedSkins.add(profile);
                continue;
            }
            EntityRenderCache.cachePlayerSkin(profile);
            cachedData = EntityRenderCache.getCachedPlayerSkin(profile);
            if (cachedData == null || !((class_13092 = cachedData.entity()) instanceof FakeClientPlayer)) continue;
            FakeClientPlayer cachedPlayer = (FakeClientPlayer)class_13092;
            this.renderPlayers.put(profile, cachedPlayer);
            this.unlockedSkins.add(profile);
        }
    }

    public static void clearCache() {
        EntityRenderCache.clearCache();
    }

    protected void addFooter() {
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46432(200).method_46431());
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.list != null) {
            this.list.method_57712(this.field_22789, this.layout);
        }
    }

    @Contract(value=" -> new")
    @NotNull
    private SearchWidget createSearchBar() {
        return new SearchWidget(0.0f, 0.0f, (float)this.getWindow().method_4486() / 4.0f, 20.0f);
    }

    @NotNull
    private class_4185 createHelpButton() {
        class_4185.class_7840 helpButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"?"), widget -> class_310.method_1551().method_1507((class_437)new RemorphedHelpScreen()));
        helpButton.method_46437(20, 20);
        helpButton.method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"remorphed.help")));
        return helpButton.method_46431();
    }

    @NotNull
    private class_4185 createTraitsButton() {
        class_5250 text = class_2561.method_43471((String)"remorphed.show_traits");
        class_4185.class_7840 traitButton = class_4185.method_46430((class_2561)text, widget -> {
            Remorphed.displayDataInMenu = !Remorphed.displayDataInMenu;
        });
        traitButton.method_46437(class_310.method_1551().field_1772.method_1727(text.getString()) + 20, 20);
        traitButton.method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"remorphed.traits")));
        return traitButton.method_46431();
    }

    @Contract(value=" -> new")
    @NotNull
    private PlayerWidget createPlayerButton() {
        return new PlayerWidget(0, 0, 20, 20, this);
    }

    @Contract(value=" -> new")
    @NotNull
    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget(0, 0, 20, 20, this);
    }

    @NotNull
    private class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (class_364 child : this.method_25396()) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

