/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.RemorphedClient;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_7919;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class EntityWidget<T extends class_1309>
extends ShapeWidget {
    private final ShapeType<T> type;
    private final T entity;
    private final int size;
    private final int id;

    public EntityWidget(int id, int x, int y, int width, int height, ShapeType<T> type, @NotNull T entity, class_437 parent, boolean isFavorite, boolean current, int availability) {
        super(x, y, width, height, parent, isFavorite, current, availability);
        this.size = (int)((float)Remorphed.CONFIG.entity_size * (1.0f / Math.max(entity.method_17682(), entity.method_17681())));
        this.type = type;
        this.entity = entity;
        this.id = id;
        entity.method_5834(true);
        this.method_47400(class_7919.method_47407((class_2561)ShapeType.createTooltipText(entity)));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(this.type, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwap2ndShapeRequest(this.type);
    }

    @Override
    protected void renderShape(class_332 guiGraphics) {
        if (Remorphed.displayDataInMenu) {
            int iconS = 16;
            int row = 0;
            int column = 0;
            ArrayList<class_2960> renderedTraits = new ArrayList<class_2960>();
            List traits = TraitRegistry.getAll(this.entity);
            for (ShapeTrait trait : traits) {
                boolean bl;
                if (trait == null || renderedTraits.contains(trait.getId()) && !trait.iconMightDiffer() || !(bl = trait.renderIcon(class_10799.field_56883, guiGraphics, this.method_46426() + column, this.method_46427() + row, 16, 16))) continue;
                if (row + 16 >= this.method_25364()) {
                    column += 16;
                    row = 0;
                } else {
                    row += 16;
                }
                if (column + 16 >= this.method_25368()) break;
                renderedTraits.add(trait.getId());
            }
        }
        try {
            int leftPos = (int)((float)this.method_46426() + (float)this.method_25368() / 2.0f);
            int topPos = (int)((float)this.method_46427() + (float)this.method_25364() * 0.75f);
            int k = leftPos - 20;
            int l = topPos - 25;
            int m = leftPos + 20;
            int n = topPos + 35;
            RemorphedClient.renderEntityInInventory(this.id, guiGraphics, k, l, m, n, this.size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, this.entity);
        }
        catch (Exception e) {
            Remorphed.LOGGER.error("Error while rendering {}", (Object)ShapeType.createTooltipText(this.entity).getString(), (Object)e);
            this.setCrashed();
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            immediate.method_22993();
            class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
            entityRenderDispatcher.method_3948(true);
            RenderSystem.getModelViewStack().popMatrix();
        }
    }

    @Override
    void sendDeleteShapePacket() {
        NetworkHandler.sendDeleteShapePacket(this.type);
    }
}

