/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import com.mojang.authlib.GameProfile;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.RemorphedClient;
import dev.tocraft.remorphed.impl.FakeClientPlayer;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.network.impl.SwapPackets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SkinWidget
extends ShapeWidget {
    private final GameProfile skin;
    private final FakeClientPlayer fakePlayer;
    private final int size;

    public SkinWidget(int x, int y, int width, int height, @NotNull GameProfile skin, @NotNull FakeClientPlayer fakePlayer, class_437 parent, boolean isFavorite, boolean isCurrent, int availability) {
        super(x, y, width, height, parent, isFavorite, isCurrent, availability);
        this.size = (int)((float)Remorphed.CONFIG.entity_size * (1.0f / Math.max(fakePlayer.method_17682(), fakePlayer.method_17681())));
        this.skin = skin;
        this.fakePlayer = fakePlayer;
        this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)skin.getName())));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(this.skin, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwapSkinRequest(this.skin);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && PlayerShape.getCurrentShape((class_1657)player) != null) {
            SwapPackets.sendSwapRequest();
        }
    }

    @Override
    protected void renderShape(class_332 guiGraphics) {
        if (this.skin != null) {
            int leftPos = (int)((float)this.method_46426() + (float)this.method_25368() / 2.0f);
            int topPos = (int)((float)this.method_46427() + (float)this.method_25364() * 0.75f);
            int k = leftPos - 20;
            int l = topPos - 25;
            int m = leftPos + 20;
            int n = topPos + 35;
            int id = this.skin.getId().hashCode();
            RemorphedClient.renderEntityInInventory(id, guiGraphics, k, l, m, n, this.size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (class_1309)this.fakePlayer);
        }
    }

    @Override
    void sendDeleteShapePacket() {
        NetworkHandler.sendDeleteShapePacket(this.skin.getId());
    }
}

