/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.command.ListPermissionsCommand;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemorphedCommand
implements CommandEvents.CommandRegistration {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.literal((String)"remorphed").requires(source -> source.hasPermission(0))).build();
        rootNode.addChild(ListPermissionsCommand.createNode());
        LiteralCommandNode removeShape = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeShape").requires(source -> {
            if (source.getEntity() == null) {
                return source.hasPermission(2);
            }
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "removeShape") || PermissionManager.canUseCommandOnOthers(player, "removeShape");
            }
            return false;
        })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)ResourceArgument.resource((CommandBuildContext)registry, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> {
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"shape").value())), null);
            return 1;
        })).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"shape").value())), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode addShape = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addShape").requires(source -> {
            if (source.getEntity() == null) {
                return source.hasPermission(2);
            }
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "addShape") || PermissionManager.canUseCommandOnOthers(player, "addShape");
            }
            return false;
        })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)ResourceArgument.resource((CommandBuildContext)registry, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> {
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"shape").value())), null);
            return 1;
        })).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"shape").value())), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode clearShapes = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clearShapes").requires(source -> {
            if (source.getEntity() == null) {
                return source.hasPermission(2);
            }
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "clearShapes") || PermissionManager.canUseCommandOnOthers(player, "clearShapes");
            }
            return false;
        })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> {
            RemorphedCommand.clearShapes((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode hasShape = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hasShape").requires(source -> {
            if (source.getEntity() == null) {
                return source.hasPermission(2);
            }
            Entity patt0$temp = source.getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                if (!Remorphed.CONFIG.usePermissions) {
                    return true;
                }
                return PermissionManager.canUseCommandOnSelf(player, "hasShape") || PermissionManager.canUseCommandOnOthers(player, "hasShape");
            }
            return false;
        })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"shape", (ArgumentType)ResourceArgument.resource((CommandBuildContext)registry, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast((SuggestionProvider)SuggestionProviders.SUMMONABLE_ENTITIES)).executes(context -> RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"shape").value())), null))).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"nbt");
            return RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"), EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType((CommandContext)context, (String)"shape").value())), nbt);
        }))))).build();
        rootNode.addChild((CommandNode)removeShape);
        rootNode.addChild((CommandNode)addShape);
        rootNode.addChild((CommandNode)clearShapes);
        rootNode.addChild((CommandNode)hasShape);
        if (Remorphed.foundSkinShifter) {
            LiteralCommandNode removeSkin = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeSkin").requires(source -> {
                if (source.getEntity() == null) {
                    return source.hasPermission(2);
                }
                Entity patt0$temp = source.getEntity();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.hasPermissions(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "removeSkin") || PermissionManager.canUseCommandOnOthers(player, "removeSkin");
                }
                return false;
            })).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
                UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((UUID)playerUUID).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), true);
                    } else {
                        RemorphedCommand.removeSkin((CommandSourceStack)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
                String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((String)playerName).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
                    } else {
                        RemorphedCommand.removeSkin((CommandSourceStack)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            })))).build();
            LiteralCommandNode addSkin = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addSkin").requires(source -> {
                if (source.getEntity() == null) {
                    return source.hasPermission(2);
                }
                Entity patt0$temp = source.getEntity();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.hasPermissions(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "addSkin") || PermissionManager.canUseCommandOnOthers(player, "addSkin");
                }
                return false;
            })).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
                UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((UUID)playerUUID).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), true);
                    } else {
                        RemorphedCommand.addSkin((CommandSourceStack)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
                String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((String)playerName).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
                    } else {
                        RemorphedCommand.addSkin((CommandSourceStack)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            })))).build();
            LiteralCommandNode clearSkins = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clearSkins").requires(source -> {
                if (source.getEntity() == null) {
                    return source.hasPermission(2);
                }
                Entity patt0$temp = source.getEntity();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.hasPermissions(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "clearSkins") || PermissionManager.canUseCommandOnOthers(player, "clearSkins");
                }
                return false;
            })).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> {
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                RemorphedCommand.clearSkins((CommandSourceStack)context.getSource(), player);
                return 1;
            }))).build();
            LiteralCommandNode hasSkin = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hasSkin").requires(source -> {
                if (source.getEntity() == null) {
                    return source.hasPermission(2);
                }
                Entity patt0$temp = source.getEntity();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    if (!Remorphed.CONFIG.usePermissions) {
                        return player.hasPermissions(2);
                    }
                    return PermissionManager.canUseCommandOnSelf(player, "hasSkin") || PermissionManager.canUseCommandOnOthers(player, "hasSkin");
                }
                return false;
            })).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"playerUUID", (ArgumentType)UuidArgument.uuid()).executes(context -> {
                UUID playerUUID = UuidArgument.getUuid((CommandContext)context, (String)"playerUUID");
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                SkinPlayerData.getSkinProfile((UUID)playerUUID).thenAccept(playerProfile -> {
                    if (playerProfile.isEmpty()) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerUUID}), true);
                    } else {
                        RemorphedCommand.hasSkin((CommandSourceStack)context.getSource(), player, (GameProfile)playerProfile.get());
                    }
                });
                return 1;
            }))).then(Commands.argument((String)"playerName", (ArgumentType)MessageArgument.message()).executes(context -> {
                String playerName = MessageArgument.getMessage((CommandContext)context, (String)"playerName").getString();
                ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                CompletableFuture.runAsync(() -> {
                    GameProfile playerProfile = SkinPlayerData.getSkinProfile((String)playerName).getNow(Optional.empty()).orElse(null);
                    if (playerProfile == null) {
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"skinshifter.invalid_player", (Object[])new Object[]{playerName}), true);
                    } else {
                        RemorphedCommand.hasSkin((CommandSourceStack)context.getSource(), player, playerProfile);
                    }
                });
                return 1;
            })))).build();
            rootNode.addChild((CommandNode)removeSkin);
            rootNode.addChild((CommandNode)addSkin);
            rootNode.addChild((CommandNode)clearSkins);
            rootNode.addChild((CommandNode)hasSkin);
        }
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static int hasShape(@NotNull CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "hasShape")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return 0;
            }
        }
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.getLevel(), id, nbt);
        MutableComponent name = Component.translatable((String)type.getEntityType().getDescriptionId());
        if (PlayerMorph.getUnlockedShapes((Player)player).containsKey(type)) {
            source.sendSuccess(() -> RemorphedCommand.lambda$hasShape$35(player, (Component)name), true);
            return 1;
        }
        source.sendSuccess(() -> RemorphedCommand.lambda$hasShape$36(player, (Component)name), true);
        return 0;
    }

    private static void removeShape(@NotNull CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "removeShape")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.getLevel(), id, nbt);
        MutableComponent name = Component.translatable((String)type.getEntityType().getDescriptionId());
        PlayerMorph.getUnlockedShapes((Player)player).remove(type);
        source.sendSuccess(() -> RemorphedCommand.lambda$removeShape$37((Component)name, player), true);
    }

    private static void addShape(@NotNull CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "addShape")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.getLevel(), id, nbt);
        MutableComponent name = Component.translatable((String)type.getEntityType().getDescriptionId());
        PlayerMorph.getUnlockedShapes((Player)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        source.sendSuccess(() -> RemorphedCommand.lambda$addShape$38(player, (Component)name), true);
    }

    private static void clearShapes(@NotNull CommandSourceStack source, ServerPlayer player) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "clearShapes")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedShapes((Player)player).clear();
        PlayerMorph.getShapeCounter((Player)player).clear();
        source.sendSuccess(() -> Component.translatable((String)"remorphed.clearShapes", (Object[])new Object[]{player.getName()}), true);
        PlayerShapeChanger.change2ndShape((ServerPlayer)player, null);
    }

    private static ShapeType<LivingEntity> getType(ServerLevel serverLevel, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType type = ShapeType.from((EntityType)BuiltInRegistries.ENTITY_TYPE.get(id).map(Holder::value).orElse(null));
        if (nbt != null) {
            CompoundTag copy = nbt.copy();
            copy.putString("id", id.toString());
            Entity loaded = EntityType.loadEntityRecursive((CompoundTag)copy, (Level)serverLevel, (EntitySpawnReason)EntitySpawnReason.LOAD, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = new ShapeType(living);
            }
        }
        return type;
    }

    private static void hasSkin(CommandSourceStack source, ServerPlayer player, @NotNull GameProfile playerProfile) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "hasSkin")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        if (PlayerMorph.getUnlockedSkinIds((Player)player).containsKey(playerProfile.getId())) {
            source.sendSuccess(() -> Component.translatable((String)"remorphed.hasSkin_success", (Object[])new Object[]{player.getName(), playerProfile.getName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"remorphed.hasSkin_fail", (Object[])new Object[]{player.getName(), playerProfile.getName()}), true);
        }
    }

    private static void removeSkin(@NotNull CommandSourceStack source, ServerPlayer player, @NotNull GameProfile playerProfile) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "removeSkin")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedSkinIds((Player)player).remove(playerProfile.getId());
        source.sendSuccess(() -> Component.translatable((String)"remorphed.removeSkin", (Object[])new Object[]{playerProfile.getName(), player.getName()}), true);
    }

    private static void addSkin(@NotNull CommandSourceStack source, ServerPlayer player, @NotNull GameProfile playerProfile) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "addSkin")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedSkinIds((Player)player).put(playerProfile.getId(), Remorphed.CONFIG.killToUnlockPlayers);
        source.sendSuccess(() -> Component.translatable((String)"remorphed.addSkin", (Object[])new Object[]{player.getName(), playerProfile.getName()}), true);
    }

    private static void clearSkins(@NotNull CommandSourceStack source, ServerPlayer player) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer executor = (ServerPlayer)entity;
            if (Remorphed.CONFIG.usePermissions && !PermissionManager.canUseCommandOnTarget(executor, player, "clearSkins")) {
                source.sendFailure((Component)Component.translatable((String)"commands.generic.permission"));
                return;
            }
        }
        PlayerMorph.getUnlockedSkinIds((Player)player).clear();
        PlayerMorph.getSkinCounter((Player)player).clear();
        source.sendSuccess(() -> Component.translatable((String)"remorphed.clearSkins", (Object[])new Object[]{player.getName()}), true);
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((ServerPlayer)player, null);
        }
    }

    private static /* synthetic */ Component lambda$addShape$38(ServerPlayer player, Component name) {
        return Component.translatable((String)"remorphed.addShape", (Object[])new Object[]{player.getName(), name});
    }

    private static /* synthetic */ Component lambda$removeShape$37(Component name, ServerPlayer player) {
        return Component.translatable((String)"remorphed.removeShape", (Object[])new Object[]{name, player.getName()});
    }

    private static /* synthetic */ Component lambda$hasShape$36(ServerPlayer player, Component name) {
        return Component.translatable((String)"remorphed.hasShape_fail", (Object[])new Object[]{player.getName(), name});
    }

    private static /* synthetic */ Component lambda$hasShape$35(ServerPlayer player, Component name) {
        return Component.translatable((String)"remorphed.hasShape_success", (Object[])new Object[]{player.getName(), name});
    }
}

