/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.handler;

import dev.tocraft.craftedcore.event.common.EntityEvents;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.permission.PermissionManager;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LivingDeathHandler
implements EntityEvents.LivingDeath {
    public InteractionResult die(LivingEntity entity, DamageSource source) {
        Entity type;
        Entity entity2;
        if (!(entity instanceof Player) && (entity2 = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)entity2;
            type = ShapeType.from((LivingEntity)entity);
            if (!(type == null || Walkers.CONFIG.blacklistPreventsUnlocking && Walkers.isPlayerBlacklisted((UUID)killer.getUUID()))) {
                boolean canUnlock;
                boolean bl = canUnlock = !Remorphed.CONFIG.usePermissions || PermissionManager.canMorphIntoType(killer, type.getEntityType());
                if (canUnlock) {
                    PlayerMorph.addKill((Player)killer, (ShapeType<? extends LivingEntity>)type);
                    if (Remorphed.CONFIG.autoTransform && PlayerMorph.getKills((Player)killer, (ShapeType<? extends LivingEntity>)type) >= Remorphed.getKillToUnlock(type.getEntityType())) {
                        PlayerShapeChanger.change2ndShape((ServerPlayer)killer, (ShapeType)type);
                        PlayerShape.updateShapes((ServerPlayer)killer, (LivingEntity)type.create((Level)killer.level(), (Player)killer));
                    }
                }
            }
        } else if (entity instanceof Player && (type = source.getEntity()) instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)type;
            if (Remorphed.foundSkinShifter) {
                boolean canUnlockPlayer;
                boolean bl = canUnlockPlayer = !Remorphed.CONFIG.usePermissions || PermissionManager.hasPermission(killer, "command.addSkin") || PermissionManager.hasPermission(killer, "*");
                if (canUnlockPlayer) {
                    PlayerMorph.addPlayerKill((Player)killer, entity.getUUID());
                }
            } else {
                PlayerMorph.addPlayerKill((Player)killer, entity.getUUID());
            }
        }
        return InteractionResult.PASS;
    }
}

