/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.handler.client;

import com.mojang.authlib.GameProfile;
import dev.tocraft.craftedcore.event.client.ClientTickEvents;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.screen.EntityPreloadScreen;
import dev.tocraft.remorphed.screen.EntityRenderCache;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class EntityRenderCacheHandler
implements ClientTickEvents.Client {
    private boolean wasInWorld = false;
    private boolean hasPreloaded = false;
    private int ticksInWorld = 0;

    public void tick(Minecraft client) {
        boolean isInWorld;
        boolean bl = isInWorld = client.level != null && client.player != null;
        if (!this.wasInWorld && isInWorld) {
            this.hasPreloaded = false;
            this.ticksInWorld = 0;
        }
        if (isInWorld && !this.hasPreloaded) {
            ++this.ticksInWorld;
            if (this.ticksInWorld >= 20) {
                this.hasPreloaded = true;
                this.preloadForPlayer(client.player);
            }
        }
        this.wasInWorld = isInWorld;
    }

    private void preloadForPlayer(LocalPlayer player) {
        if (player == null) {
            return;
        }
        try {
            EntityRenderCache.preloadEntities((Player)player);
            EntityRenderCache.preloadPlayerSkins((Player)player);
            this.startPreRendering(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startPreRendering(LocalPlayer player) {
        List<ShapeType<?>> currentUnlockedShapes = Remorphed.getUnlockedShapes((Player)player);
        List<GameProfile> unlockedSkins = Remorphed.getUnlockedSkins((Player)player);
        ArrayList currentFilteredShapes = new ArrayList();
        HashSet<EntityType> seenTypes = new HashSet<EntityType>();
        for (ShapeType<?> shapeType : currentUnlockedShapes) {
            if (!seenTypes.add(shapeType.getEntityType())) continue;
            currentFilteredShapes.add(shapeType);
        }
        ArrayList<Mob> entitiesToRender = new ArrayList<Mob>();
        for (ShapeType shapeType : currentFilteredShapes) {
            LivingEntity livingEntity;
            EntityRenderCache.CachedEntityData cached = EntityRenderCache.getCachedEntity(shapeType);
            if (cached == null || !((livingEntity = cached.entity()) instanceof Mob)) continue;
            Mob mob = (Mob)livingEntity;
            entitiesToRender.add(mob);
        }
        if (!entitiesToRender.isEmpty()) {
            Minecraft.getInstance().setScreen((Screen)new EntityPreloadScreen(entitiesToRender, unlockedSkins));
        }
    }
}

