/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.network;

import dev.tocraft.craftedcore.client.CraftedCoreClient;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.craftedcore.network.client.ClientNetworking;
import dev.tocraft.remorphed.impl.PlayerMorph;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.remorphed.network.PermissionCheckPacket;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, ClientNetworking::handleUnlockedSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.PERMISSION_RESPONSE, PermissionCheckPacket::handlePermissionResponse);
    }

    public static void handleUnlockedSyncPacket(ModernNetworking.Context context, @NotNull CompoundTag compound) {
        UUID uuid = UUIDUtil.uuidFromIntArray((int[])((int[])compound.getIntArray("uuid").orElseThrow()));
        HashMap unlockedShapes = new HashMap();
        if (compound.contains("UnlockedShapes")) {
            compound.getListOrEmpty("UnlockedShapes").forEach(entryTag -> {
                EntityType eType = BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)((String)((CompoundTag)entryTag).getString("id").orElseThrow()))).map(Holder::value).orElse(null);
                int variant = ((CompoundTag)entryTag).getIntOr("variant", -1);
                int killAmount = ((CompoundTag)entryTag).getIntOr("killAmount", 0);
                unlockedShapes.put(ShapeType.from((EntityType)eType, (int)variant), killAmount);
            });
        }
        HashMap unlockedSkins = new HashMap();
        if (compound.contains("UnlockedSkins")) {
            compound.getListOrEmpty("UnlockedSkins").forEach(entryTag -> {
                UUID unlockedSkinUUID = UUIDUtil.uuidFromIntArray((int[])((int[])((CompoundTag)entryTag).getIntArray("uuid").orElseThrow()));
                int killAmount = ((CompoundTag)entryTag).getIntOr("killAmount", 0);
                unlockedSkins.put(unlockedSkinUUID, killAmount);
            });
        }
        HashMap shapeCounter = new HashMap();
        HashMap skinCounter = new HashMap();
        if (compound.contains("MorphCounter")) {
            compound.getListOrEmpty("MorphCounter").forEach(entry -> {
                boolean isSkin = (Boolean)((CompoundTag)entry).getBoolean("isSkin").orElseThrow();
                int count = ((CompoundTag)entry).getIntOr("counter", 0);
                if (isSkin) {
                    UUID skinId = UUIDUtil.uuidFromIntArray((int[])((int[])((CompoundTag)entry).getIntArray("uuid").orElseThrow()));
                    skinCounter.put(skinId, count);
                } else {
                    ResourceLocation typeId = ResourceLocation.parse((String)((String)((CompoundTag)entry).getString("id").orElseThrow()));
                    int typeVariantId = ((CompoundTag)entry).getIntOr("variant", -1);
                    shapeCounter.put(ShapeType.from((EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId).map(Holder::value).orElse(null), (int)typeVariantId), count);
                }
            });
        }
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.level().getPlayerByUUID(uuid);
            if (syncTarget != null) {
                PlayerMorph.getUnlockedShapes(player).clear();
                PlayerMorph.getUnlockedShapes(player).putAll(unlockedShapes);
                PlayerMorph.getUnlockedSkinIds(player).clear();
                PlayerMorph.getUnlockedSkinIds(player).putAll(unlockedSkins);
                PlayerMorph.getShapeCounter(player).clear();
                PlayerMorph.getShapeCounter(player).putAll(shapeCounter);
                PlayerMorph.getSkinCounter(player).clear();
                PlayerMorph.getSkinCounter(player).putAll(skinCounter);
            }
        });
    }

    private static void handleFavoriteSyncPacket(ModernNetworking.Context context, CompoundTag tag) {
        ClientNetworking.runOrQueue(context, player -> {
            PlayerMorph.getFavoriteShapes(player).clear();
            PlayerMorph.getFavoriteSkinIds(player).clear();
            ListTag shapeIds = tag.getListOrEmpty("FavoriteShapes");
            ListTag skinIds = tag.getListOrEmpty("FavoriteSkins");
            shapeIds.forEach(compound -> PlayerMorph.getFavoriteShapes(player).add(ShapeType.from((CompoundTag)((CompoundTag)compound))));
            skinIds.forEach(skinId -> PlayerMorph.getFavoriteSkinIds(player).add(UUIDUtil.uuidFromIntArray((int[])((int[])skinId.asIntArray().orElseThrow()))));
        });
    }

    public static void runOrQueue(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}

