/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.permission.neoforge;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.NotNull;

public class PermissionManagerImpl {
    private static final ConcurrentMap<String, PermissionNode<Boolean>> PERMISSION_NODES = new ConcurrentHashMap<String, PermissionNode<Boolean>>();

    public static boolean hasPermission(@NotNull ServerPlayer player, @NotNull String permission) {
        PermissionNode node = (PermissionNode)PERMISSION_NODES.get(permission);
        return node != null ? ((Boolean)PermissionAPI.getPermission((ServerPlayer)player, (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue() : player.hasPermissions(2);
    }

    private static void createNode(@NotNull String permission) {
        PERMISSION_NODES.computeIfAbsent(permission, key -> new PermissionNode("remorphed", key, PermissionTypes.BOOLEAN, (player, playerUUID, context) -> player != null && player.hasPermissions(2), new PermissionDynamicContextKey[0]));
    }

    public static void registerNodesEvent(PermissionGatherEvent.Nodes event) {
        PermissionManagerImpl.createNode("morph");
        PermissionManagerImpl.createNode("bypass.lock");
        PermissionManagerImpl.createNode("command.addShape");
        PermissionManagerImpl.createNode("command.removeShape");
        PermissionManagerImpl.createNode("command.clearShapes");
        PermissionManagerImpl.createNode("command.hasShape");
        PermissionManagerImpl.createNode("command.addSkin");
        PermissionManagerImpl.createNode("command.removeSkin");
        PermissionManagerImpl.createNode("command.clearSkins");
        PermissionManagerImpl.createNode("command.hasSkin");
        PermissionManagerImpl.createNode("command.addShape.self");
        PermissionManagerImpl.createNode("command.removeShape.self");
        PermissionManagerImpl.createNode("command.clearShapes.self");
        PermissionManagerImpl.createNode("command.hasShape.self");
        PermissionManagerImpl.createNode("command.addSkin.self");
        PermissionManagerImpl.createNode("command.removeSkin.self");
        PermissionManagerImpl.createNode("command.clearSkins.self");
        PermissionManagerImpl.createNode("command.hasSkin.self");
        PermissionManagerImpl.createNode("command.addShape.others");
        PermissionManagerImpl.createNode("command.removeShape.others");
        PermissionManagerImpl.createNode("command.clearShapes.others");
        PermissionManagerImpl.createNode("command.hasShape.others");
        PermissionManagerImpl.createNode("command.addSkin.others");
        PermissionManagerImpl.createNode("command.removeSkin.others");
        PermissionManagerImpl.createNode("command.clearSkins.others");
        PermissionManagerImpl.createNode("command.hasSkin.others");
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            ResourceLocation key = EntityType.getKey((EntityType)entityType);
            PermissionManagerImpl.createNode("type." + String.valueOf(key));
        });
        event.addNodes((PermissionNode[])PERMISSION_NODES.values().toArray(PermissionNode[]::new));
    }
}

