/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen;

import com.mojang.authlib.GameProfile;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.RemorphedClient;
import dev.tocraft.remorphed.screen.RemorphedMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EntityPreloadScreen
extends Screen {
    private final List<Mob> entitiesToRender;
    private final List<GameProfile> skinsToRender;
    private int currentIndex = 0;
    private int finishedTicks = 0;
    private static final int ENTITIES_PER_FRAME = 10;
    private static final int WAIT_AFTER_RENDER = 5;

    public EntityPreloadScreen(List<Mob> entities, List<GameProfile> skins) {
        super((Component)Component.literal((String)"Preloading"));
        this.entitiesToRender = entities;
        this.skinsToRender = skins;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (int rendered = 0; this.currentIndex < this.entitiesToRender.size() && rendered < 10; ++rendered) {
            Mob entity = this.entitiesToRender.get(this.currentIndex);
            int listIndex = this.skinsToRender.size() + this.currentIndex;
            int row = listIndex / Remorphed.CONFIG.shapes_per_row;
            int col = listIndex % Remorphed.CONFIG.shapes_per_row;
            int id = row * Remorphed.CONFIG.shapes_per_row + col;
            try {
                int size = (int)((float)Remorphed.CONFIG.entity_size * (1.0f / Math.max(entity.getBbHeight(), entity.getBbWidth())));
                RemorphedClient.renderEntityInInventory(id, guiGraphics, -10000, -10000, -9900, -9900, size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, (LivingEntity)entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.entitiesToRender.size()) {
            ++this.finishedTicks;
            if (this.finishedTicks >= 5) {
                Minecraft.getInstance().setScreen((Screen)new RemorphedMenu());
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }
}

