/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen;

import com.mojang.authlib.GameProfile;
import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.impl.FakeClientPlayer;
import dev.tocraft.walkers.api.variant.ShapeType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EntityRenderCache {
    private static final Map<ShapeType<?>, CachedEntityData> ENTITY_CACHE = new ConcurrentHashMap();
    private static final Map<GameProfile, CachedEntityData> PLAYER_CACHE = new ConcurrentHashMap<GameProfile, CachedEntityData>();

    public static void preloadEntities(Player player) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        List allShapes = ShapeType.getAllTypes((Level)player.level());
        for (ShapeType type : allShapes) {
            if (ENTITY_CACHE.containsKey(type)) continue;
            try {
                LivingEntity entity = type.create((Level)minecraft.level, player);
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                EntityRenderCache.prepareStaticEntity(mob);
                ENTITY_CACHE.putIfAbsent(type, new CachedEntityData((LivingEntity)mob));
            }
            catch (Exception e) {
                Remorphed.LOGGER.warn("[Remorphed] Failed to pre-load entity for type {}: {}", (Object)type.getEntityType().getDescriptionId(), (Object)e.getMessage());
            }
        }
    }

    public static void preloadPlayerSkins(Player player) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        List<GameProfile> unlockedSkins = Remorphed.getUnlockedSkins(player);
        for (GameProfile profile : unlockedSkins) {
            if (profile.getId().equals(player.getUUID()) || PLAYER_CACHE.containsKey(profile)) continue;
            try {
                FakeClientPlayer fakePlayer = new FakeClientPlayer(minecraft.level, profile);
                fakePlayer.setInvulnerable(true);
                PLAYER_CACHE.putIfAbsent(profile, new CachedEntityData((LivingEntity)fakePlayer));
            }
            catch (Exception e) {
                Remorphed.LOGGER.warn("[Remorphed] Failed to pre-load player skin for profile {}: {}", (Object)profile.getName(), (Object)e.getMessage());
            }
        }
    }

    private static void prepareStaticEntity(Mob mob) {
        mob.setNoAi(true);
        mob.setInvulnerable(true);
        if (mob instanceof Slime) {
            Slime slime = (Slime)mob;
            slime.setSize(1, true);
        } else if (mob instanceof MagmaCube) {
            MagmaCube magmaCube = (MagmaCube)mob;
            magmaCube.setSize(1, true);
        }
        mob.setGlowingTag(true);
    }

    @Nullable
    public static CachedEntityData getCachedEntity(ShapeType<?> type) {
        return ENTITY_CACHE.get(type);
    }

    @Nullable
    public static CachedEntityData getCachedPlayerSkin(GameProfile profile) {
        return PLAYER_CACHE.get(profile);
    }

    public static void cacheEntity(ShapeType<?> type, Player player) {
        if (ENTITY_CACHE.containsKey(type)) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        try {
            LivingEntity entity = type.create((Level)minecraft.level, player);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                EntityRenderCache.prepareStaticEntity(mob);
                ENTITY_CACHE.putIfAbsent(type, new CachedEntityData((LivingEntity)mob));
            }
        }
        catch (Exception e) {
            Remorphed.LOGGER.warn("[Remorphed] Failed to cache entity on-demand: {}", (Object)type.getEntityType().getDescriptionId(), (Object)e);
        }
    }

    public static void cachePlayerSkin(GameProfile profile) {
        if (PLAYER_CACHE.containsKey(profile)) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        try {
            FakeClientPlayer fakePlayer = new FakeClientPlayer(minecraft.level, profile);
            fakePlayer.setInvulnerable(true);
            PLAYER_CACHE.putIfAbsent(profile, new CachedEntityData((LivingEntity)fakePlayer));
        }
        catch (Exception e) {
            Remorphed.LOGGER.warn("[Remorphed] Failed to cache player skin on-demand: {}", (Object)profile.getName(), (Object)e);
        }
    }

    public static void clearCache() {
        ENTITY_CACHE.clear();
        PLAYER_CACHE.clear();
    }

    public static int getCachedEntityCount() {
        return ENTITY_CACHE.size();
    }

    public static int getCachedPlayerSkinCount() {
        return PLAYER_CACHE.size();
    }

    public record CachedEntityData(LivingEntity entity) {
    }
}

