/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.network.NetworkHandler;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.network.impl.SwapPackets;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PlayerWidget
extends AbstractButton {
    private final Screen parent;
    private final boolean willCache = true;

    public PlayerWidget(int x, int y, int width, int height, Screen parent) {
        super(x, y, width, height, Component.nullToEmpty((String)"Head"));
        this.parent = parent;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"remorphed.player_icon")));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ResourceLocation skinLocation = player.getSkin().texture();
            if (Remorphed.foundSkinShifter && !player.getUUID().equals(SkinShifter.getCurrentSkin((Player)player))) {
                CompletableFuture<Optional<PlayerSkin>> skin = PlayerWidget.getPlayerSkin((Player)player);
                skinLocation = skin.getNow(Optional.empty()).map(PlayerSkin::texture).orElse(skinLocation);
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skinLocation, this.getX(), this.getY(), 8.0f, 8.0f, this.getWidth(), this.getHeight(), 8, 8, 64, 64);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, skinLocation, this.getX(), this.getY(), 40.0f, 8.0f, this.getWidth(), this.getHeight(), 8, 8, 64, 64);
        }
        if (this.isHoveredOrFocused()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/head_focus.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 16, 16, 16, 16);
        }
    }

    public void onPress() {
        if (Minecraft.getInstance().player != null) {
            if (PlayerShape.getCurrentShape((Player)Minecraft.getInstance().player) != null) {
                SwapPackets.sendSwapRequest();
                this.parent.onClose();
            }
            if (Remorphed.foundSkinShifter && SkinShifter.getCurrentSkin((Player)Minecraft.getInstance().player) != Minecraft.getInstance().player.getUUID()) {
                NetworkHandler.sendResetSkinPacket();
                this.parent.onClose();
            }
        }
    }

    public void updateWidgetNarration(NarrationElementOutput builder) {
    }

    @NotNull
    private static CompletableFuture<Optional<PlayerSkin>> getPlayerSkin(Player player) {
        CompletableFuture profileFuture = SkinPlayerData.getSkinProfile((UUID)player.getUUID());
        return profileFuture.thenApply(profile -> profile.map(gameProfile -> Minecraft.getInstance().getSkinManager().getInsecureSkin(gameProfile)));
    }
}

