/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.remorphed.screen.widget.ShapeWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ShapeListWidget
extends ContainerObjectSelectionList<ShapeRow> {
    private static final int ITEM_HEIGHT = 35;

    public ShapeListWidget(Minecraft minecraft, int width, @NotNull HeaderAndFooterLayout layout) {
        super(minecraft, width, layout.getContentHeight(), layout.getHeaderHeight(), 35);
    }

    public int addRow(ShapeWidget[] widgets) {
        return this.addEntry((AbstractSelectionList.Entry)new ShapeRow(widgets));
    }

    public int rowHeight() {
        return this.itemHeight;
    }

    public void clearEntries() {
        super.clearEntries();
    }

    public int getRowWidth() {
        return Remorphed.CONFIG.row_width;
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (ShapeRow child : this.children()) {
            if (!child.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public static class ShapeRow
    extends ContainerObjectSelectionList.Entry<ShapeRow> {
        private final ShapeWidget[] widgets;

        public ShapeRow(ShapeWidget[] widgets) {
            this.widgets = widgets;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float delta) {
            for (int i = 0; i < this.widgets.length; ++i) {
                ShapeWidget widget = this.widgets[i];
                if (widget == null) continue;
                int w = width / Remorphed.CONFIG.shapes_per_row;
                widget.setPosition(left + w * i, top);
                widget.setSize(w, height);
                widget.render(guiGraphics, mouseX, mouseY, delta);
            }
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return List.of(this.widgets);
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.widgets);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            for (GuiEventListener guiEventListener : this.children()) {
                if (!guiEventListener.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
    }
}

