/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.remorphed.screen.widget;

import dev.tocraft.remorphed.Remorphed;
import dev.tocraft.walkers.network.impl.SwapPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public abstract class ShapeWidget
extends AbstractButton {
    private final Screen parent;
    private boolean crashed = false;
    private boolean isFavorite;
    private final boolean isCurrent;
    private int availability;

    public ShapeWidget(float x, float y, float width, float height, Screen parent, boolean isFavorite, boolean isCurrent, int availability) {
        super((int)x, (int)y, (int)width, (int)height, Component.nullToEmpty((String)"WOLF"));
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = isCurrent;
        this.availability = availability;
    }

    protected abstract void sendFavoriteRequest(boolean var1);

    protected abstract void sendSwap2ndShapeRequest();

    protected abstract void renderShape(GuiGraphics var1);

    protected void setCrashed() {
        this.crashed = true;
    }

    private void deletePoint() {
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        if (this.availability > 0) {
            --this.availability;
            this.sendDeleteShapePacket();
        } else if (this.isCurrent) {
            SwapPackets.sendSwapRequest();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.isHovered() && Minecraft.getInstance().player != null) {
            if (button == 1) {
                this.isFavorite = !this.isFavorite;
                this.sendFavoriteRequest(this.isFavorite);
                this.playDownSound(Minecraft.getInstance().getSoundManager());
            } else if (button == 2 && this.availability != -1) {
                this.deletePoint();
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (!this.crashed) {
            if (this.isHoveredOrFocused()) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/focused.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 48, 32, 48, 32);
            }
            if (Remorphed.displayDataInMenu && this.availability > 0) {
                String s = String.valueOf(this.availability);
                int w = this.parent.getFont().width(s);
                guiGraphics.drawString(this.parent.getFont(), s, this.getX() + this.getWidth() - w - this.getWidth() / 8, (int)((double)this.getY() + (double)this.getHeight() * 0.125), -1, false);
            } else if (this.availability == 0) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/deleted.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 48, 32, 48, 32);
            }
            this.renderShape(guiGraphics);
            if (this.isCurrent) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/selected.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 48, 32, 48, 32);
            }
            if (this.isFavorite) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, Remorphed.id("textures/gui/favorite.png"), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 48, 32, 48, 32);
            }
        }
    }

    public void onPress() {
        if (!this.isCurrent) {
            this.sendSwap2ndShapeRequest();
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.parent.onClose();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.active && this.visible && this.isHovered() && keyCode == 88 && this.availability != -1) {
            this.deletePoint();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    abstract void sendDeleteShapePacket();

    public void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

