/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.extrememonsters.init.ExtremeMonstersModBlockEntities;
import net.mcreator.extrememonsters.world.inventory.IceMakerGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class IceMakerBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    private final SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, null);
    private final EnergyStorage energyStorage = new EnergyStorage(800000, Integer.MAX_VALUE, Integer.MAX_VALUE, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                IceMakerBlockEntity.this.setChanged();
                IceMakerBlockEntity.this.level.sendBlockUpdated(IceMakerBlockEntity.this.worldPosition, IceMakerBlockEntity.this.level.getBlockState(IceMakerBlockEntity.this.worldPosition), IceMakerBlockEntity.this.level.getBlockState(IceMakerBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                IceMakerBlockEntity.this.setChanged();
                IceMakerBlockEntity.this.level.sendBlockUpdated(IceMakerBlockEntity.this.worldPosition, IceMakerBlockEntity.this.level.getBlockState(IceMakerBlockEntity.this.worldPosition), IceMakerBlockEntity.this.level.getBlockState(IceMakerBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };
    private final FluidTank fluidTank = new FluidTank(500000, fs -> fs.getFluid() == Fluids.WATER){

        protected void onContentsChanged() {
            super.onContentsChanged();
            IceMakerBlockEntity.this.setChanged();
            IceMakerBlockEntity.this.level.sendBlockUpdated(IceMakerBlockEntity.this.worldPosition, IceMakerBlockEntity.this.level.getBlockState(IceMakerBlockEntity.this.worldPosition), IceMakerBlockEntity.this.level.getBlockState(IceMakerBlockEntity.this.worldPosition), 2);
        }
    };

    public IceMakerBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ExtremeMonstersModBlockEntities.ICE_MAKER.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        Tag tag = compound.get("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
        if ((tag = compound.get("fluidTank")) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.fluidTank.readFromNBT(lookupProvider, compoundTag);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
        compound.put("fluidTank", (Tag)this.fluidTank.writeToNBT(lookupProvider, new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"ice_maker");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new IceMakerGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"\u00a7bIce Maker");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 1;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return index != 2;
    }

    public SidedInvWrapper getItemHandler() {
        return this.handler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

