/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.extrememonsters.EMItemHandler;
import net.mcreator.extrememonsters.init.ExtremeMonstersModBlockEntities;
import net.mcreator.extrememonsters.init.ExtremeMonstersModFluids;
import net.mcreator.extrememonsters.world.inventory.MolecularAssemblerGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class MolecularAssemblerBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final EMItemHandler inventory = new EMItemHandler(11, new boolean[]{true, true, true, true, true, true, true, true, false, false, false}, new boolean[]{false, false, false, false, false, false, false, false, true, false, true});
    private final EnergyStorage energyStorage = new EnergyStorage(20000000, Integer.MAX_VALUE, Integer.MAX_VALUE, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                MolecularAssemblerBlockEntity.this.setChanged();
                MolecularAssemblerBlockEntity.this.level.sendBlockUpdated(MolecularAssemblerBlockEntity.this.worldPosition, MolecularAssemblerBlockEntity.this.level.getBlockState(MolecularAssemblerBlockEntity.this.worldPosition), MolecularAssemblerBlockEntity.this.level.getBlockState(MolecularAssemblerBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                MolecularAssemblerBlockEntity.this.setChanged();
                MolecularAssemblerBlockEntity.this.level.sendBlockUpdated(MolecularAssemblerBlockEntity.this.worldPosition, MolecularAssemblerBlockEntity.this.level.getBlockState(MolecularAssemblerBlockEntity.this.worldPosition), MolecularAssemblerBlockEntity.this.level.getBlockState(MolecularAssemblerBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };
    private final FluidTank fluidTank = new FluidTank(10000, fs -> fs.getFluid() == ExtremeMonstersModFluids.MOLECULAR_SOLVENT.get()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            MolecularAssemblerBlockEntity.this.setChanged();
            MolecularAssemblerBlockEntity.this.level.sendBlockUpdated(MolecularAssemblerBlockEntity.this.worldPosition, MolecularAssemblerBlockEntity.this.level.getBlockState(MolecularAssemblerBlockEntity.this.worldPosition), MolecularAssemblerBlockEntity.this.level.getBlockState(MolecularAssemblerBlockEntity.this.worldPosition), 2);
        }
    };

    public MolecularAssemblerBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)ExtremeMonstersModBlockEntities.MOLECULAR_ASSEMBLER.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        Tag tag;
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            NonNullList tmp = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)compound, (NonNullList)tmp, (HolderLookup.Provider)lookupProvider);
            this.setItems((NonNullList<ItemStack>)tmp);
        }
        if ((tag = compound.get("energyStorage")) instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
        if ((tag = compound.get("fluidTank")) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.fluidTank.readFromNBT(lookupProvider, compoundTag);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            NonNullList<ItemStack> tmp = this.getItems();
            ContainerHelper.saveAllItems((CompoundTag)compound, tmp, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
        compound.put("fluidTank", (Tag)this.fluidTank.writeToNBT(lookupProvider, new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"molecular_assembler");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack result;
        ItemStack stack = this.inventory.getStackInSlot(index);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (stack.getCount() <= count) {
            result = stack;
            this.inventory.setStackInSlot(index, ItemStack.EMPTY);
        } else {
            result = stack.copy();
            result.setCount(count);
            stack.shrink(count);
            this.inventory.setStackInSlot(index, stack);
        }
        this.setChanged();
        return result;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.inventory.getStackInSlot(index);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.inventory.setStackInSlot(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setStackInSlot(index, stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void clearContent() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new MolecularAssemblerGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"\u00a7dMolecular Assembler");
    }

    protected NonNullList<ItemStack> getItems() {
        NonNullList list = NonNullList.withSize((int)this.inventory.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            list.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return list;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        for (int i = 0; i < stacks.size() && i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)stacks.get(i));
        }
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index != 8;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (index == 0) {
            return false;
        }
        if (index == 1) {
            return false;
        }
        if (index == 2) {
            return false;
        }
        if (index == 3) {
            return false;
        }
        if (index == 4) {
            return false;
        }
        if (index == 5) {
            return false;
        }
        if (index == 6) {
            return false;
        }
        if (index == 7) {
            return false;
        }
        return index != 9;
    }

    public EMItemHandler getItemHandler() {
        return this.inventory;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

