/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.entity;

import javax.annotation.Nullable;
import net.mcreator.extrememonsters.init.ExtremeMonstersModEntities;
import net.mcreator.extrememonsters.init.ExtremeMonstersModItems;
import net.mcreator.extrememonsters.procedures.BlackHoleBombProjectileBoomProcedure;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class BlackHoleBombProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)ExtremeMonstersModItems.BLACK_HOLE_BOMB.get());
    private int knockback = 0;

    public BlackHoleBombProjectileEntity(EntityType<? extends BlackHoleBombProjectileEntity> type, Level world) {
        super(type, world);
    }

    public BlackHoleBombProjectileEntity(EntityType<? extends BlackHoleBombProjectileEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    public BlackHoleBombProjectileEntity(EntityType<? extends BlackHoleBombProjectileEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ExtremeMonstersModItems.BLACK_HOLE_BOMB.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        BlackHoleBombProjectileBoomProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        BlackHoleBombProjectileBoomProcedure.execute((LevelAccessor)this.level(), blockHitResult.getBlockPos().getX(), blockHitResult.getBlockPos().getY(), blockHitResult.getBlockPos().getZ(), (Entity)this);
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static BlackHoleBombProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return BlackHoleBombProjectileEntity.shoot(world, entity, source, 1.0f, 0.0, 0);
    }

    public static BlackHoleBombProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return BlackHoleBombProjectileEntity.shoot(world, entity, source, pullingPower * 1.0f, 0.0, 0);
    }

    public static BlackHoleBombProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        BlackHoleBombProjectileEntity entityarrow = new BlackHoleBombProjectileEntity((EntityType<? extends BlackHoleBombProjectileEntity>)((EntityType)ExtremeMonstersModEntities.BLACK_HOLE_BOMB_PROJECTILE.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(false);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static BlackHoleBombProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        BlackHoleBombProjectileEntity entityarrow = new BlackHoleBombProjectileEntity((EntityType<? extends BlackHoleBombProjectileEntity>)((EntityType)ExtremeMonstersModEntities.BLACK_HOLE_BOMB_PROJECTILE.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(0.0);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

