/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.entity;

import java.util.function.Predicate;
import net.mcreator.extrememonsters.init.ExtremeMonstersModBlocks;
import net.mcreator.extrememonsters.init.ExtremeMonstersModEntities;
import net.mcreator.extrememonsters.procedures.ReturnFollowingSetProcedure;
import net.mcreator.extrememonsters.procedures.TamableTrackerRightClickOnThisEntityProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class TamableTrackerEntity
extends TamableAnimal {
    public TamableTrackerEntity(EntityType<TamableTrackerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.refreshDimensions();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f){

            public boolean canUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canContinueToUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{((Block)ExtremeMonstersModBlocks.BLACK_HOLE_MATTER_BLOCK.get()).asItem()}), false));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canContinueToUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canContinueToUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TamableTrackerEntity.this.getX();
                double y = TamableTrackerEntity.this.getY();
                double z = TamableTrackerEntity.this.getZ();
                TamableTrackerEntity entity = TamableTrackerEntity.this;
                Level world = TamableTrackerEntity.this.level();
                return super.canContinueToUse() && ReturnFollowingSetProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        TamableTrackerEntity entity = this;
        Level world = this.level();
        TamableTrackerRightClickOnThisEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        TamableTrackerEntity retval = (TamableTrackerEntity)((EntityType)ExtremeMonstersModEntities.TAMABLE_TRACKER.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ExtremeMonstersModBlocks.BLACK_HOLE_MATTER_BLOCK.get())}).test(stack);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(0.5f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.5);
        builder = builder.add(Attributes.MAX_HEALTH, 200.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

