/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.network;

import net.mcreator.extrememonsters.ExtremeMonstersMod;
import net.mcreator.extrememonsters.procedures.AntiTrackerItemActionEffectProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record AntiTrackerItemActionMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AntiTrackerItemActionMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extreme_monsters", (String)"key_anti_tracker_item_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AntiTrackerItemActionMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new AntiTrackerItemActionMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AntiTrackerItemActionMessage> type() {
        return TYPE;
    }

    public static void handleData(AntiTrackerItemActionMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> AntiTrackerItemActionMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            AntiTrackerItemActionEffectProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ExtremeMonstersMod.addNetworkMessage(TYPE, STREAM_CODEC, AntiTrackerItemActionMessage::handleData);
    }
}

