/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.network;

import java.util.function.Supplier;
import net.mcreator.extrememonsters.ExtremeMonstersMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ExtremeMonstersModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"extreme_monsters");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ExtremeMonstersMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        ExtremeMonstersMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extreme_monsters", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"extreme_monsters", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean giveES = true;
        public boolean tob_on_off = false;
        public boolean apc_on_off = false;
        public boolean allow_nether = false;
        public boolean allow_end = false;
        public double basic_health = 0.0;
        public boolean nab_shot = false;
        public double nab_shot_time = 0.0;
        public double ac_tick = -1.0;
        public double ac_second = 0.0;
        public boolean can_elytra_fly = false;
        public boolean flight_ring_bug_fix = false;
        public double mirror_of_despair_damage_saved = 0.0;
        public boolean mirror_of_despair_work = false;
        public double mirror_of_despair_timer = 0.0;
        public double shield_capacity = 0.0;
        public boolean slash_all = false;
        public boolean perfect_abyss_despawn_mode = false;
        public boolean test_qustn = true;
        public boolean perfect_invincibility = true;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("giveES", this.giveES);
            nbt.putBoolean("tob_on_off", this.tob_on_off);
            nbt.putBoolean("apc_on_off", this.apc_on_off);
            nbt.putBoolean("allow_nether", this.allow_nether);
            nbt.putBoolean("allow_end", this.allow_end);
            nbt.putDouble("basic_health", this.basic_health);
            nbt.putBoolean("nab_shot", this.nab_shot);
            nbt.putDouble("nab_shot_time", this.nab_shot_time);
            nbt.putDouble("ac_tick", this.ac_tick);
            nbt.putDouble("ac_second", this.ac_second);
            nbt.putBoolean("can_elytra_fly", this.can_elytra_fly);
            nbt.putBoolean("flight_ring_bug_fix", this.flight_ring_bug_fix);
            nbt.putDouble("mirror_of_despair_damage_saved", this.mirror_of_despair_damage_saved);
            nbt.putBoolean("mirror_of_despair_work", this.mirror_of_despair_work);
            nbt.putDouble("mirror_of_despair_timer", this.mirror_of_despair_timer);
            nbt.putDouble("shield_capacity", this.shield_capacity);
            nbt.putBoolean("slash_all", this.slash_all);
            nbt.putBoolean("perfect_abyss_despawn_mode", this.perfect_abyss_despawn_mode);
            nbt.putBoolean("test_qustn", this.test_qustn);
            nbt.putBoolean("perfect_invincibility", this.perfect_invincibility);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.giveES = nbt.getBoolean("giveES");
            this.tob_on_off = nbt.getBoolean("tob_on_off");
            this.apc_on_off = nbt.getBoolean("apc_on_off");
            this.allow_nether = nbt.getBoolean("allow_nether");
            this.allow_end = nbt.getBoolean("allow_end");
            this.basic_health = nbt.getDouble("basic_health");
            this.nab_shot = nbt.getBoolean("nab_shot");
            this.nab_shot_time = nbt.getDouble("nab_shot_time");
            this.ac_tick = nbt.getDouble("ac_tick");
            this.ac_second = nbt.getDouble("ac_second");
            this.can_elytra_fly = nbt.getBoolean("can_elytra_fly");
            this.flight_ring_bug_fix = nbt.getBoolean("flight_ring_bug_fix");
            this.mirror_of_despair_damage_saved = nbt.getDouble("mirror_of_despair_damage_saved");
            this.mirror_of_despair_work = nbt.getBoolean("mirror_of_despair_work");
            this.mirror_of_despair_timer = nbt.getDouble("mirror_of_despair_timer");
            this.shield_capacity = nbt.getDouble("shield_capacity");
            this.slash_all = nbt.getBoolean("slash_all");
            this.perfect_abyss_despawn_mode = nbt.getBoolean("perfect_abyss_despawn_mode");
            this.test_qustn = nbt.getBoolean("test_qustn");
            this.perfect_invincibility = nbt.getBoolean("perfect_invincibility");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "extreme_monsters_mapvars";
        public boolean Extreme = false;
        public boolean is_killed_hyper_enderdragon = false;
        public boolean infinity_tracker_defender_working = false;
        public double after_extreme_mode_start = 0.0;
        public boolean spawn_basic_tracker = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.Extreme = nbt.getBoolean("Extreme");
            this.is_killed_hyper_enderdragon = nbt.getBoolean("is_killed_hyper_enderdragon");
            this.infinity_tracker_defender_working = nbt.getBoolean("infinity_tracker_defender_working");
            this.after_extreme_mode_start = nbt.getDouble("after_extreme_mode_start");
            this.spawn_basic_tracker = nbt.getBoolean("spawn_basic_tracker");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("Extreme", this.Extreme);
            nbt.putBoolean("is_killed_hyper_enderdragon", this.is_killed_hyper_enderdragon);
            nbt.putBoolean("infinity_tracker_defender_working", this.infinity_tracker_defender_working);
            nbt.putDouble("after_extreme_mode_start", this.after_extreme_mode_start);
            nbt.putBoolean("spawn_basic_tracker", this.spawn_basic_tracker);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "extreme_monsters_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.giveES = original.giveES;
            clone.allow_nether = original.allow_nether;
            clone.allow_end = original.allow_end;
            clone.basic_health = original.basic_health;
            clone.can_elytra_fly = original.can_elytra_fly;
            clone.flight_ring_bug_fix = original.flight_ring_bug_fix;
            clone.slash_all = original.slash_all;
            clone.perfect_abyss_despawn_mode = original.perfect_abyss_despawn_mode;
            clone.perfect_invincibility = original.perfect_invincibility;
            if (!event.isWasDeath()) {
                clone.tob_on_off = original.tob_on_off;
                clone.apc_on_off = original.apc_on_off;
                clone.nab_shot = original.nab_shot;
                clone.nab_shot_time = original.nab_shot_time;
                clone.ac_tick = original.ac_tick;
                clone.ac_second = original.ac_second;
                clone.mirror_of_despair_damage_saved = original.mirror_of_despair_damage_saved;
                clone.mirror_of_despair_work = original.mirror_of_despair_work;
                clone.mirror_of_despair_timer = original.mirror_of_despair_timer;
                clone.shield_capacity = original.shield_capacity;
                clone.test_qustn = original.test_qustn;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

