/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.procedures;

import javax.annotation.Nullable;
import net.mcreator.extrememonsters.entity.NomalArrowEntity;
import net.mcreator.extrememonsters.init.ExtremeMonstersModAttributes;
import net.mcreator.extrememonsters.init.ExtremeMonstersModEntities;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class HyperSkeletonArrowProcedure {
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        HyperSkeletonArrowProcedure.execute((Event)event, event.getEntity());
    }

    public static void execute(Entity entity) {
        HyperSkeletonArrowProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        LivingEntity _livingEntity1;
        if (entity == null) {
            return;
        }
        if (entity instanceof Skeleton && (entity instanceof LivingEntity && (_livingEntity1 = (LivingEntity)entity).getAttributes().hasAttribute(ExtremeMonstersModAttributes.HYPER_MOBS) ? _livingEntity1.getAttribute(ExtremeMonstersModAttributes.HYPER_MOBS).getBaseValue() : 0.0) == 1.0) {
            LivingEntity livingEntity;
            if (entity instanceof Mob) {
                Mob _mobEnt = (Mob)entity;
                livingEntity = _mobEnt.getTarget();
            } else {
                livingEntity = null;
            }
            if (livingEntity != null) {
                for (int index0 = 0; index0 < 5; ++index0) {
                    Entity _shootFrom = entity;
                    Level projectileLevel = _shootFrom.level();
                    if (projectileLevel.isClientSide()) continue;
                    Projectile _entityToSpawn = new Object(){

                        public Projectile getArrow(Level level, Entity shooter, float damage, final int knockback, final byte piercing) {
                            NomalArrowEntity entityToSpawn = new NomalArrowEntity(this, (EntityType)ExtremeMonstersModEntities.NOMAL_ARROW.get(), level){

                                public byte getPierceLevel() {
                                    return piercing;
                                }

                                @Override
                                protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
                                    if (knockback > 0) {
                                        double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                                        Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)knockback * 0.6 * d1);
                                        if (vec3.lengthSqr() > 0.0) {
                                            livingEntity.push(vec3.x, 0.1, vec3.z);
                                        }
                                    }
                                }
                            };
                            entityToSpawn.setOwner(shooter);
                            entityToSpawn.setBaseDamage(damage);
                            entityToSpawn.setSilent(true);
                            entityToSpawn.igniteForSeconds(100.0f);
                            entityToSpawn.setCritArrow(true);
                            entityToSpawn.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                            return entityToSpawn;
                        }
                    }.getArrow(projectileLevel, entity, 1.0f, 1, (byte)-25);
                    _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                    _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.0f, 30.0f);
                    projectileLevel.addFreshEntity((Entity)_entityToSpawn);
                }
            }
        }
    }
}

