/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.procedures;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.extrememonsters.init.ExtremeMonstersModAttributes;
import net.mcreator.extrememonsters.init.ExtremeMonstersModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class HyprWitherPullProcedure {
    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        HyprWitherPullProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        HyprWitherPullProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        LivingEntity _livingEntity1;
        if (entity == null) {
            return;
        }
        if (entity instanceof WitherBoss && (entity instanceof LivingEntity && (_livingEntity1 = (LivingEntity)entity).getAttributes().hasAttribute(ExtremeMonstersModAttributes.HYPER_MOBS) ? _livingEntity1.getAttribute(ExtremeMonstersModAttributes.HYPER_MOBS).getBaseValue() : 0.0) == 1.0 && entity.getPersistentData().getDouble("hyper_wither_pull") > 0.0) {
            ServerLevel _level;
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SQUID_INK, x, y, z, 20, 1.0, 1.0, 1.0, 0.1);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, y, z, 20, 1.0, 1.0, 1.0, 0.2);
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither.ambient")), SoundSource.HOSTILE, 1.5f, 2.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.wither.ambient")), SoundSource.HOSTILE, 1.5f, 2.0f, false);
                }
            }
            entity.getPersistentData().putDouble("hyper_wither_pull", entity.getPersistentData().getDouble("hyper_wither_pull") - 1.0);
            if (entity.getPersistentData().getDouble("hyper_wither_pull") == 1.0) {
                Vec3 _center = new Vec3(x, y, z);
                List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(12.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    LivingEntity _entity;
                    if (entityiterator instanceof WitherBoss) continue;
                    entityiterator.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"extreme_monsters:abyssal_damage")))), 250.0f);
                    if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                        _entity.addEffect(new MobEffectInstance(ExtremeMonstersModMobEffects.MELT, 60, 3));
                    }
                    if (!(entity instanceof LivingEntity) || (_entity = (LivingEntity)entity).level().isClientSide()) continue;
                    _entity.addEffect(new MobEffectInstance(ExtremeMonstersModMobEffects.BLACK_HOLE, 60, 1));
                }
                if (world instanceof Level && !(_level = (Level)world).isClientSide()) {
                    _level.explode(null, x, y, z, 32.0f, Level.ExplosionInteraction.MOB);
                }
            }
        }
    }
}

