/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.extrememonsters.procedures;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.extrememonsters.init.ExtremeMonstersModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class VaporEmitterUseTickProcedure {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        VaporEmitterUseTickProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        VaporEmitterUseTickProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("VaporEmitterUseTick") > 0.0) {
            entity.getPersistentData().putDouble("VaporEmitterUseTick", entity.getPersistentData().getDouble("VaporEmitterUseTick") - 1.0);
        }
        if (entity.getPersistentData().getDouble("VaporEmitterUseTick") <= 100.0 && entity.getPersistentData().getDouble("VaporEmitterUseTick") > 0.0) {
            ServerLevel _level;
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 5, 3.0, 3.0, 3.0, 0.8);
            }
            if (Math.random() <= 0.2 && world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.lava.extinguish")), SoundSource.MASTER, 0.5f, 0.8f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.lava.extinguish")), SoundSource.MASTER, 0.5f, 0.8f, false);
                }
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(6.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                LivingEntity _entity;
                if (!(entityiterator instanceof Mob)) continue;
                entityiterator.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"extreme_monsters:steam_damage")))), 12.0f);
                if (!(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).level().isClientSide()) continue;
                _entity.addEffect(new MobEffectInstance(ExtremeMonstersModMobEffects.MELT, 60, 0, false, false));
            }
        }
    }
}

