/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.ConfiguratorManager;
import net.sssubtlety.dispenser_configurator.behavior.GenericDispenserBehavior;
import net.sssubtlety.dispenser_configurator.behavior.predicate.DualSet;
import net.sssubtlety.dispenser_configurator.behavior.predicate.universal.AllowSetUniversalAcceptor;
import net.sssubtlety.dispenser_configurator.behavior.target.DispenserBehaviorTarget;

public class Configurator {
    public static final ConfiguratorManager MANAGER = new ConfiguratorManager("dispenser_configurators");
    public static final int MAX_PRIORITY = 0x3FFFFFFF;
    public static final int MIN_PRIORITY = -1073741824;
    public static final String GREATER_THAN_MAX_FALLBACK = " greater than maximum allowable priority. Using max priority instead: 1073741823";
    public static final String LESS_THAN_MIN_FALLBACK = " less than minimum allowable priority. Using min priority instead: -1073741824";
    public final class_2960 id;
    public boolean exclusive;
    public final int priority;
    private final List<DispenserBehaviorTarget> targets;
    private final Collection<class_1792> items;
    private final DualSet<class_2248> blockPredicate;
    private final DualSet<class_1299<?>> entityPredicate;
    private GenericDispenserBehavior resolvedBehavior;

    Configurator(class_2960 id, int priority) {
        this.id = id;
        this.exclusive = false;
        this.priority = this.clampPriority(priority);
        this.targets = new LinkedList<DispenserBehaviorTarget>();
        this.items = new LinkedList<class_1792>();
        this.blockPredicate = new DualSet();
        this.entityPredicate = new DualSet();
    }

    private int clampPriority(int priority) {
        if (priority > 0x3FFFFFFF) {
            DispenserConfigurator.LOGGER.error("Trying to construct a Configurator ({}) with greater than maximum allowable priority. Using max priority instead: 1073741823", (Object)this.id);
            return 0x3FFFFFFF;
        }
        if (priority < -1073741824) {
            DispenserConfigurator.LOGGER.error("Trying to construct a Configurator ({}) with less than minimum allowable priority. Using min priority instead: -1073741824", (Object)this.id);
            return -1073741824;
        }
        return priority;
    }

    protected Collection<class_1792> getItems() {
        return this.items;
    }

    protected Collection<class_2248> getBlockAllowSet() {
        return this.blockPredicate.allowSet;
    }

    protected Collection<class_2248> getBlockDenySet() {
        return this.blockPredicate.denySet;
    }

    protected Collection<class_1299<?>> getEntityAllowSet() {
        return this.entityPredicate.allowSet;
    }

    protected Collection<class_1299<?>> getEntityDenySet() {
        return this.entityPredicate.denySet;
    }

    public void addToListFromString(String listKey, String idString) {
        Objects.requireNonNull((Keyed)KeyManager.keyMappings.get((Object)listKey)).resolveIdString(this, idString);
    }

    public boolean intersects(Configurator other) {
        return this.blockPredicate.intersects(other.blockPredicate) || this.entityPredicate.intersects(other.entityPredicate);
    }

    public GenericDispenserBehavior resolveBehavior() {
        if (this.resolvedBehavior == null) {
            this.resolvedBehavior = new GenericDispenserBehavior(this.targets, this.blockPredicate, this.entityPredicate, this.id, this.exclusive);
        }
        return this.resolvedBehavior;
    }

    public int comparePriority(Configurator other) {
        if (this.priority == other.priority) {
            boolean otherLow;
            boolean thisLow = this.isLowPriority();
            return thisLow == (otherLow = other.isLowPriority()) ? 0 : (thisLow ? 1 : -1);
        }
        return other.priority - this.priority;
    }

    public boolean isLowPriority() {
        return this.blockPredicate.allowSet instanceof AllowSetUniversalAcceptor && this.entityPredicate.allowSet instanceof AllowSetUniversalAcceptor;
    }

    public void addTarget(DispenserBehaviorTarget target) {
        if (this.exclusive) {
            throw new IllegalStateException("Trying to add unreachable target after an exclusive target.");
        }
        this.exclusive = target.isExclusive();
        this.targets.add(target);
    }

    public List<String> getTargetNames() {
        return this.targets.stream().map(DispenserBehaviorTarget::getName).collect(Collectors.toList());
    }

    protected static class KeyManager {
        private static final ImmutableMap<String, Keyed<?>> keyMappings;

        protected KeyManager() {
        }

        private static <K, V> void mapAllToValue(Collection<K> keys, V value, ImmutableMap.Builder<K, V> builder) {
            for (K key : keys) {
                builder.put(key, value);
            }
        }

        static {
            ImmutableMap.Builder keyMappingsBuilder = ImmutableMap.builder();
            keyMappingsBuilder.put((Object)"items", new Keyed(class_7923.field_41178, Configurator::getItems));
            KeyManager.mapAllToValue(ConfiguratorManager.Keys.BLOCK_ALLOW_KEYS, new Keyed(class_7923.field_41175, Configurator::getBlockAllowSet), keyMappingsBuilder);
            KeyManager.mapAllToValue(ConfiguratorManager.Keys.BLOCK_DENY_KEYS, new Keyed(class_7923.field_41175, Configurator::getBlockDenySet), keyMappingsBuilder);
            KeyManager.mapAllToValue(ConfiguratorManager.Keys.ENTITY_ALLOW_KEYS, new Keyed(class_7923.field_41177, Configurator::getEntityAllowSet), keyMappingsBuilder);
            KeyManager.mapAllToValue(ConfiguratorManager.Keys.ENTITY_DENY_KEYS, new Keyed(class_7923.field_41177, Configurator::getEntityDenySet), keyMappingsBuilder);
            keyMappings = keyMappingsBuilder.build();
        }
    }

    private record Keyed<T>(class_2378<T> registry, Function<Configurator, Collection<T>> collectionFunction) {
        public void resolveIdString(Configurator configurator, String idString) {
            this.collectionFunction.apply(configurator).addAll(Keyed.resolveIdString(idString, this.registry));
        }

        public static <T> Collection<T> resolveIdString(String idString, class_2378<T> registry) {
            if (idString.startsWith("#")) {
                return StreamSupport.stream(registry.method_40286(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)class_2960.method_60654((String)idString.substring(1)))).spliterator(), false).map(class_6880::comp_349).toList();
            }
            return registry.method_17966(class_2960.method_60654((String)idString)).map(List::of).orElseGet(() -> {
                DispenserConfigurator.LOGGER.error("No \"{}\" with id: {}", (Object)registry.method_30517().method_29177(), (Object)idString);
                return List.of();
            });
        }
    }
}

