/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1799;
import net.minecraft.class_2342;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.Configurator;
import net.sssubtlety.dispenser_configurator.behavior.GenericDispenserBehavior;
import net.sssubtlety.dispenser_configurator.behavior.PriorityBehaviorMultiMap;
import net.sssubtlety.dispenser_configurator.behavior.target.DispenserBehaviorTarget;

public class ConfiguratorManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String PRIORITY_FALL_BACK_ERROR = "\"priority\" must be an integer, \"MAX\", or \"MIN\". Using default priority 0 instead.";
    private static final String NON_STRING_ERROR_MSG = "Found non-string element in 'items'. Only strings are allowed. ";
    private static final PriorityBehaviorMultiMap BEHAVIOR_MAP = new PriorityBehaviorMultiMap();
    private static Map<class_2960, JsonElement> LOADER;

    public ConfiguratorManager(String dataType) {
        super(GSON, dataType);
    }

    public static boolean tryReplaceDispensation(class_2342 blockPointer, class_1799 stack, int i) {
        Collection<GenericDispenserBehavior> behaviors = BEHAVIOR_MAP.get(stack);
        if (behaviors != null) {
            for (GenericDispenserBehavior behavior : behaviors) {
                stack = behavior.method_10135(blockPointer, stack);
                blockPointer.comp_1970().method_5447(i, stack);
                if (!behavior.method_27954()) continue;
                return true;
            }
        }
        return false;
    }

    public static Configurator read(class_2960 id, JsonObject jsonObject) {
        int priority = ConfiguratorManager.getPriority(jsonObject, id);
        Configurator configurator = new Configurator(id, priority);
        JsonArray targetElements = class_3518.method_15292((JsonObject)jsonObject, (String)"targets", (JsonArray)new JsonArray());
        if (!targetElements.isEmpty()) {
            for (JsonElement targetElement : targetElements) {
                if (!targetElement.isJsonPrimitive()) continue;
                String targetString2 = targetElement.getAsString();
                DispenserBehaviorTarget target = DispenserBehaviorTarget.TARGET_FACTORY_MAP.get(targetString2).get();
                if (target == null) {
                    DispenserConfigurator.LOGGER.error("Found unrecognized target: {}", (Object)targetString2);
                    continue;
                }
                if (configurator.exclusive) {
                    List<String> targetNames = configurator.getTargetNames();
                    DispenserConfigurator.LOGGER.warn("Found target after exclusive target: {}. Exclusive target: {}", (Object)targetString2, (Object)targetNames.get(targetNames.size() - 1));
                    continue;
                }
                configurator.addTarget(target);
            }
        } else {
            DispenserBehaviorTarget.TARGET_FACTORY_MAP.forEach((targetString, targetSupplier) -> configurator.addTarget((DispenserBehaviorTarget)targetSupplier.get()));
        }
        JsonArray itemStrings = class_3518.method_15261((JsonObject)jsonObject, (String)"items");
        if (itemStrings == null) {
            DispenserConfigurator.LOGGER.error("Could not find required 'items' array in configurator '{}'.", (Object)id);
        } else if (itemStrings.isEmpty()) {
            DispenserConfigurator.LOGGER.error("'items' entry is empty in configurator '{}'.", (Object)id);
        } else {
            for (JsonElement jsonElement : itemStrings) {
                ConfiguratorManager.getIdString(jsonElement).ifPresent(idString -> configurator.addToListFromString("items", (String)idString));
            }
            for (String list_key : Keys.ALL_LIST_KEYS) {
                if (!jsonObject.has(list_key)) continue;
                for (JsonElement listElement : class_3518.method_15261((JsonObject)jsonObject, (String)list_key)) {
                    ConfiguratorManager.getIdString(listElement).ifPresent(idString -> configurator.addToListFromString(list_key, (String)idString));
                }
            }
        }
        return configurator;
    }

    private static int getPriority(JsonObject jsonObject, class_2960 id) {
        if (jsonObject.has("priority")) {
            JsonElement priorityElement = jsonObject.get("priority");
            if (priorityElement.isJsonPrimitive()) {
                JsonPrimitive priorityPrimitive = priorityElement.getAsJsonPrimitive();
                if (priorityPrimitive.isNumber()) {
                    int priority = priorityPrimitive.getAsInt();
                    if (priority > 0x3FFFFFFF) {
                        DispenserConfigurator.LOGGER.warn("\"priority\" in dispenser_configurator {} greater than maximum allowable priority. Using max priority instead: 1073741823", (Object)id);
                        return 0x3FFFFFFF;
                    }
                    if (priority < -1073741824) {
                        DispenserConfigurator.LOGGER.warn("\"priority\" in dispenser_configurator {} less than minimum allowable priority. Using min priority instead: -1073741824", (Object)id);
                        return -1073741824;
                    }
                    return priority;
                }
                if (priorityPrimitive.isString()) {
                    String priorityString = priorityPrimitive.getAsString();
                    if (priorityString.equals("MAX")) {
                        return 0x3FFFFFFF;
                    }
                    if (priorityString.equals("MIN")) {
                        return -1073741824;
                    }
                    DispenserConfigurator.LOGGER.error("Found unrecognized \"priority\" string in dispenser_configurator {}: {}. \"priority\" must be an integer, \"MAX\", or \"MIN\". Using default priority 0 instead.", (Object)id, (Object)priorityString);
                } else {
                    DispenserConfigurator.LOGGER.error("Found unrecognized type for \"priority\" in dispenser_configurator {}: {}. \"priority\" must be an integer, \"MAX\", or \"MIN\". Using default priority 0 instead.", (Object)id, (Object)class_3518.method_15266((JsonElement)priorityPrimitive));
                }
            } else {
                DispenserConfigurator.LOGGER.error("Found unrecognized type for \"priority\" in dispenser_configurator {}: {}. \"priority\" must be an integer, \"MAX\", or \"MIN\". Using default priority 0 instead.", (Object)id, (Object)class_3518.method_15266((JsonElement)priorityElement));
            }
        }
        return 0;
    }

    private static Optional<String> getIdString(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            return Optional.of(primitive.getAsString());
        }
        DispenserConfigurator.LOGGER.error(NON_STRING_ERROR_MSG);
        return Optional.empty();
    }

    public class_2960 getFabricId() {
        return DispenserConfigurator.ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singleton(ResourceReloadListenerKeys.TAGS);
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        LOADER = loader;
    }

    public static void postTagBinding() {
        if (LOADER == null) {
            return;
        }
        PriorityBehaviorMultiMap.Builder mapBuilder = PriorityBehaviorMultiMap.builder();
        LOADER.forEach((identifier, element) -> {
            if (element.isJsonObject()) {
                try {
                    mapBuilder.createMappedBehavior(ConfiguratorManager.read(identifier, element.getAsJsonObject()));
                }
                catch (Exception e) {
                    DispenserConfigurator.LOGGER.error("Error creating configurator", (Throwable)e);
                }
            }
        });
        BEHAVIOR_MAP.reset(mapBuilder);
        LOADER = null;
    }

    public static interface Keys {
        public static final String targets = "targets";
        public static final String priority = "priority";
        public static final String MAX = "MAX";
        public static final String MIN = "MIN";
        public static final String ITEMS = "items";
        public static final String BLOCK_ALLOW_LIST = "block_allow_list";
        public static final String BLOCK_DENY_LIST = "block_deny_list";
        public static final String ENTITY_ALLOW_LIST = "entity_allow_list";
        public static final String ENTITY_DENY_LIST = "entity_deny_list";
        public static final String BLOCK_WHITE_LIST = "block_white_list";
        public static final String BLOCK_BLACK_LIST = "block_black_list";
        public static final String ENTITY_WHITE_LIST = "entity_white_list";
        public static final String ENTITY_BLACK_LIST = "entity_black_list";
        public static final ImmutableList<String> BLOCK_ALLOW_KEYS = ImmutableList.of((Object)"block_allow_list", (Object)"block_white_list");
        public static final ImmutableList<String> BLOCK_DENY_KEYS = ImmutableList.of((Object)"block_deny_list", (Object)"block_black_list");
        public static final ImmutableList<String> ENTITY_ALLOW_KEYS = ImmutableList.of((Object)"entity_allow_list", (Object)"entity_white_list");
        public static final ImmutableList<String> ENTITY_DENY_KEYS = ImmutableList.of((Object)"entity_deny_list", (Object)"entity_black_list");
        public static final ImmutableList<String> ALL_LIST_KEYS = (ImmutableList)Streams.concat((Stream[])new Stream[]{BLOCK_ALLOW_KEYS.stream(), BLOCK_DENY_KEYS.stream(), ENTITY_ALLOW_KEYS.stream(), ENTITY_DENY_KEYS.stream()}).collect(ImmutableList.toImmutableList());
    }
}

