/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.sssubtlety.dispenser_configurator.behavior.predicate.DualSet;
import net.sssubtlety.dispenser_configurator.behavior.target.DispenserBehaviorTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.DualListPredicated;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class GenericDispenserBehavior
extends class_2969 {
    protected final ImmutableList<DispenserBehaviorTarget> targets;
    protected final DualSet<class_2248> blockList;
    protected final DualSet<class_1299<?>> entityList;
    protected final class_2960 id;
    protected final boolean exclusive;

    public GenericDispenserBehavior(List<DispenserBehaviorTarget> targets, DualSet<class_2248> blockPredicate, DualSet<class_1299<?>> entityPredicate, class_2960 id, boolean exclusive) {
        this.exclusive = exclusive;
        List dualListPredicatedTargets = targets.stream().map(target -> {
            Optional<Object> optional;
            if (target instanceof DualListPredicated) {
                DualListPredicated dualListPredicated = (DualListPredicated)((Object)target);
                optional = Optional.of(dualListPredicated);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).flatMap(Optional::stream).toList();
        if (!blockPredicate.isEmpty()) {
            boolean usedBlockPredicate = false;
            for (DualListPredicated target2 : dualListPredicatedTargets) {
                usedBlockPredicate |= target2.considerDualList(blockPredicate);
            }
            if (!usedBlockPredicate) {
                field_34020.warn("Block{}", (Object)GenericDispenserBehavior.getListNotUsedString(id));
            }
        }
        if (!entityPredicate.isEmpty()) {
            boolean usedEntityPredicate = false;
            for (DualListPredicated target2 : dualListPredicatedTargets) {
                usedEntityPredicate |= target2.considerDualList(entityPredicate);
            }
            if (!usedEntityPredicate) {
                field_34020.warn("Entity{}", (Object)GenericDispenserBehavior.getListNotUsedString(id));
            }
        }
        for (DispenserBehaviorTarget target3 : targets) {
            target3.finishInitialization();
        }
        this.targets = ImmutableList.copyOf(targets);
        this.blockList = blockPredicate;
        this.entityList = entityPredicate;
        this.id = id;
    }

    @NotNull
    private static String getListNotUsedString(class_2960 id) {
        return " list in " + String.valueOf(id) + " was not used by any targets.";
    }

    public static <T> void fillIfEmpty(MutableObject<T> mutable, Supplier<T> filler) {
        if (mutable.getValue() == null) {
            mutable.setValue(filler.get());
        }
    }

    public class_1799 method_10135(class_2342 pointer, class_1799 stack) {
        if (pointer.comp_1967().method_8608()) {
            return stack;
        }
        this.method_27955(false);
        MutableObject mutableBlockHitResult = new MutableObject();
        MutableObject mutableEntities = new MutableObject();
        FakePlayer dummy = FakePlayer.get((class_3218)pointer.comp_1967());
        for (DispenserBehaviorTarget target : this.targets) {
            dummy.method_6122(class_1268.field_5808, stack);
            class_1661 dummyInventory = dummy.method_31548();
            if (target.behaviorDelegation(pointer, (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918), dummy, (MutableObject<class_3965>)mutableBlockHitResult, (MutableObject<List<class_1297>>)mutableEntities)) {
                stack = dummy.method_5998(class_1268.field_5808);
                dummy.method_6122(class_1268.field_5808, class_1799.field_8037);
                target.onSuccess(pointer);
                this.method_27955(true);
                break;
            }
            dummyInventory.method_5448();
        }
        return stack;
    }
}

