/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import net.minecraft.class_1792;
import net.minecraft.class_7923;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.Configurator;
import net.sssubtlety.dispenser_configurator.behavior.SortedList;

public class PrioritizedConfigurators
extends SortedList<Configurator> {
    protected static Configurator cast(Object o) {
        Configurator configurator;
        return o instanceof Configurator ? (configurator = (Configurator)o) : null;
    }

    protected static void logConflictError(class_1792 item, Configurator current, Configurator conflict) {
        DispenserConfigurator.LOGGER.error("Conflicting exclusive configurators found for item: {}. Configurators: '{}', '{}'.\nSkipping '{}'.", (Object)class_7923.field_41178.method_10221((Object)item), (Object)current.id, (Object)conflict.id, (Object)conflict.id);
    }

    public PrioritizedConfigurators() {
        super(Configurator::comparePriority, PrioritizedConfigurators::cast);
    }

    public PrioritizedConfigurators(Configurator configurator) {
        this();
        this.append(configurator);
    }

    public void add(class_1792 item, Configurator configurator) {
        int firstIndex = this.find(configurator);
        if (firstIndex >= 0) {
            Configurator equalPriorityConfigurator = (Configurator)this.get(firstIndex);
            if (configurator.intersects(equalPriorityConfigurator) && equalPriorityConfigurator.exclusive) {
                if (configurator.exclusive) {
                    PrioritizedConfigurators.logConflictError(item, equalPriorityConfigurator, configurator);
                }
                return;
            }
        } else {
            firstIndex = -firstIndex - 1;
        }
        if (firstIndex < this.size()) {
            this.insert(firstIndex, configurator);
        } else {
            this.append(configurator);
        }
    }
}

