/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.sssubtlety.dispenser_configurator.behavior.Configurator;
import net.sssubtlety.dispenser_configurator.behavior.GenericDispenserBehavior;
import net.sssubtlety.dispenser_configurator.behavior.PrioritizedConfigurators;

public class PriorityBehaviorMultiMap {
    private ImmutableMap<class_1792, ImmutableList<GenericDispenserBehavior>> behaviors = ImmutableMap.of();

    public static Builder builder() {
        return new Builder();
    }

    public void reset(Builder builder) {
        this.behaviors = builder.toBehaviorMap();
    }

    public Collection<GenericDispenserBehavior> get(class_1799 stack) {
        return (Collection)this.behaviors.get((Object)stack.method_7909());
    }

    public static class Builder {
        private final Map<class_1792, PrioritizedConfigurators> configuratorMap = new HashMap<class_1792, PrioritizedConfigurators>();

        protected Builder() {
        }

        public ImmutableMap<class_1792, ImmutableList<GenericDispenserBehavior>> toBehaviorMap() {
            return (ImmutableMap)this.configuratorMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf(((PrioritizedConfigurators)entry.getValue()).stream().map(Configurator::resolveBehavior).toList())));
        }

        public void createMappedBehavior(Configurator configurator) {
            for (class_1792 item : configurator.getItems()) {
                PrioritizedConfigurators currentConfigurators = this.configuratorMap.get(item);
                if (currentConfigurators == null) {
                    this.configuratorMap.put(item, new PrioritizedConfigurators(configurator));
                    continue;
                }
                currentConfigurators.add(item, configurator);
            }
        }
    }
}

