/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;

public class SortedList<T>
extends ArrayList<T> {
    protected final Comparator<T> comparator;
    protected final Function<Object, T> caster;

    public SortedList(Comparator<T> comparator, Function<Object, T> caster) {
        this.comparator = comparator;
        this.caster = caster;
    }

    protected int find(T t) {
        return Collections.binarySearch(this, t, this.comparator);
    }

    @Override
    @Deprecated
    public T set(int index, T element) throws UnsupportedOperationException {
        throw SortedList.unsupportedIndexOperation("setting");
    }

    @Override
    public boolean add(T t) {
        this.insert(Math.abs(this.find(t)), t);
        return true;
    }

    protected final void append(T element) {
        super.add(element);
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        throw SortedList.unsupportedIndexOperation("adding");
    }

    protected final void insert(int index, T element) {
        super.add(index, element);
    }

    @Override
    public boolean remove(Object o) {
        T t = this.caster.apply(o);
        if (t == null) {
            return false;
        }
        int index = this.find(t);
        if (index >= 0) {
            super.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T t : c) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw SortedList.unsupportedIndexOperation("adding");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            Object t = itr.next();
            if (c.contains(t)) continue;
            itr.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    @Deprecated
    public void sort(Comparator<? super T> c) {
        super.sort(c);
    }

    @Override
    public boolean contains(Object o) {
        T t = this.caster.apply(o);
        return t != null && this.find(t) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        T t = this.caster.apply(o);
        if (t == null) {
            return -1;
        }
        return this.find(t);
    }

    @Override
    public int lastIndexOf(Object o) {
        T t = this.caster.apply(o);
        if (t == null) {
            return -1;
        }
        int index = this.find(t);
        if (index < 0) {
            return -1;
        }
        int size = this.size();
        while (index < size && this.comparator.compare(t, this.get(index)) == 0) {
            ++index;
        }
        return index;
    }

    protected static UnsupportedOperationException unsupportedIndexOperation(String indexMethodDescription) {
        return new UnsupportedOperationException("SortedList does not support " + indexMethodDescription + " by index.");
    }
}

