/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior.predicate;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.sssubtlety.dispenser_configurator.behavior.predicate.AllowSet;
import net.sssubtlety.dispenser_configurator.behavior.predicate.CollectionPredicate;
import net.sssubtlety.dispenser_configurator.behavior.predicate.DenySet;
import org.jetbrains.annotations.NotNull;

public class DualSet<T>
implements CollectionPredicate<T> {
    public static final String ADD_NOT_SUPPORTED = "add is not supported. Use allow or deny instead.";
    public final DenySet<T> denySet;
    public final AllowSet<T> allowSet;

    public DualSet() {
        this.denySet = new DenySet();
        this.allowSet = new AllowSet();
    }

    public DualSet(Collection<T> denyList, Collection<T> allowList) {
        this.denySet = new DenySet<T>(denyList);
        this.allowSet = new AllowSet<T>(allowList);
    }

    @Override
    public int size() {
        return this.denySet.size() + this.allowSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.denySet.isEmpty() && this.allowSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.denySet.contains(o) || this.allowSet.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getCombinedStream().iterator();
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.getCombinedStream().toArray();
    }

    @Override
    public <T_> T_ @NotNull [] toArray(T_ @NotNull [] a) {
        if (a.length <= this.size()) {
            Iterator<T> itr = this.iterator();
            for (int i = 0; i < a.length; ++i) {
                a[i] = itr.next();
            }
        }
        return this.toArray();
    }

    @Override
    public boolean add(T t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(ADD_NOT_SUPPORTED);
    }

    public boolean allow(T t) {
        if (t == null) {
            return false;
        }
        return this.allowSet.add(t);
    }

    public boolean deny(T t) {
        return this.denySet.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.denySet.remove(o) || this.allowSet.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        Collection<T> combinedView = this.getCombinedView();
        return combinedView.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(ADD_NOT_SUPPORTED);
    }

    public boolean allowAll(@NotNull Collection<? extends T> c) {
        return this.allowSet.addAll(c);
    }

    public boolean denyAll(@NotNull Collection<? extends T> c) {
        return this.denySet.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.denySet.removeAll(c) | this.allowSet.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.denySet.retainAll(c) | this.allowSet.retainAll(c);
    }

    @Override
    public void clear() {
        this.denySet.clear();
        this.allowSet.clear();
    }

    @Override
    public boolean test(T t) {
        return this.denySet.test(t) && this.allowSet.test(t);
    }

    private Collection<T> getCombinedView() {
        LinkedList<T> combinedView = new LinkedList<T>(this.denySet);
        combinedView.addAll(this.allowSet);
        return combinedView;
    }

    private Stream<T> getCombinedStream() {
        return Stream.concat(this.allowSet.stream(), this.denySet.stream());
    }

    @Override
    public boolean intersects(CollectionPredicate<T> other) {
        for (Object t : this.allowSet) {
            if (!this.denySet.test(t) || !other.test(t)) continue;
            return true;
        }
        return false;
    }
}

