/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior.target;

import net.sssubtlety.dispenser_configurator.behavior.predicate.DualSet;
import net.sssubtlety.dispenser_configurator.behavior.target.DualListedTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.TypedTarget;
import org.jetbrains.annotations.Nullable;

public abstract class DoubleTypedTarget<A, B>
extends DualListedTarget {
    protected DualSet<A> aDualSet;
    protected DualSet<B> bDualSet;

    @Override
    protected final boolean allows(Object candidate) {
        A aCandidate = this.tryCastA(candidate);
        if (aCandidate != null) {
            return this.aDualSet.test(aCandidate);
        }
        B bCandidate = this.tryCastB(candidate);
        if (bCandidate != null) {
            return this.bDualSet.test(bCandidate);
        }
        return false;
    }

    public final <T_> boolean considerDualList(DualSet<? extends T_> dualSet) {
        DualSet<Object> potentialAList = TypedTarget.tryBuildList(dualSet, this::tryCastA);
        if (potentialAList != null) {
            if (this.aDualSet == null) {
                this.aDualSet = potentialAList;
                return true;
            }
            return TypedTarget.failReset();
        }
        DualSet<Object> potentialBList = TypedTarget.tryBuildList(dualSet, this::tryCastB);
        if (potentialBList != null) {
            if (this.bDualSet == null) {
                this.bDualSet = potentialBList;
                return true;
            }
            return TypedTarget.failReset();
        }
        return false;
    }

    @Nullable
    protected abstract A tryCastA(Object var1);

    @Nullable
    protected abstract B tryCastB(Object var1);
}

