/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior.target;

import java.util.function.Function;
import java.util.function.Predicate;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.predicate.CollectionPredicate;
import net.sssubtlety.dispenser_configurator.behavior.predicate.DualSet;
import net.sssubtlety.dispenser_configurator.behavior.target.DualListedTarget;
import org.jetbrains.annotations.Nullable;

public abstract class TypedTarget<T>
extends DualListedTarget {
    protected DualSet<T> dualSet;

    @Nullable
    protected static <T_, T> DualSet<T> tryBuildList(DualSet<? extends T_> source, Function<Object, T> caster) {
        DualSet tList = new DualSet();
        boolean allowAdded = TypedTarget.tryFillCollectionPredicate(source.allowSet, caster, tList::allow, true);
        boolean denyAdded = TypedTarget.tryFillCollectionPredicate(source.denySet, caster, tList::deny, !allowAdded);
        return allowAdded || denyAdded ? tList : null;
    }

    protected static <T_, T> boolean tryFillCollectionPredicate(CollectionPredicate<? extends T_> source, Function<Object, T> caster, Predicate<T> filler, boolean first) {
        if (source.isEmpty()) {
            return false;
        }
        for (Object t_ : source) {
            T t = caster.apply(t_);
            if (filler.test(t)) {
                first = false;
                continue;
            }
            if (first) break;
            DispenserConfigurator.LOGGER.error("Found inconsistent types in considerCollection.");
            break;
        }
        return !first;
    }

    protected static boolean failReset() {
        DispenserConfigurator.LOGGER.error("Trying to re-set CollectionPredicate but it must only be set once.");
        return false;
    }

    @Override
    protected final boolean allows(Object candidate) {
        T tCandidate = this.tryCast(candidate);
        if (tCandidate != null) {
            return this.dualSet.test(tCandidate);
        }
        return false;
    }

    public final <T_> boolean considerDualList(DualSet<? extends T_> dualSet) {
        DualSet<Object> potentialList = TypedTarget.tryBuildList(dualSet, this::tryCast);
        if (potentialList != null) {
            if (this.dualSet == null) {
                this.dualSet = potentialList;
                return true;
            }
            return TypedTarget.failReset();
        }
        return false;
    }

    @Nullable
    protected abstract T tryCast(Object var1);
}

