/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.sssubtlety.dispenser_configurator.behavior.GenericDispenserBehavior;
import net.sssubtlety.dispenser_configurator.behavior.target.BlockOnUseTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.DropTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.EntityOnInteractTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.FailTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.ItemUseOnBlockTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.ItemUseOnEntityTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.ItemUseOnOffsetBlockTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.ItemUseTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.PlaceBlockTarget;
import net.sssubtlety.dispenser_configurator.behavior.target.abstraction.DispenserBehaviorTarget;
import net.sssubtlety.dispenser_configurator.util.CodecUtil;
import net.sssubtlety.dispenser_configurator.util.TaggableId;

public record Configurator(ImmutableSet<DispenserBehaviorTarget.Creator> targetCreators, ImmutableSet<TaggableId> itemIds, int priority, Optional<ImmutableSet<TaggableId>> allowedBlockIds, Optional<ImmutableSet<TaggableId>> deniedBlockIds, Optional<ImmutableSet<TaggableId>> allowedEntityIds, Optional<ImmutableSet<TaggableId>> deniedEntityIds) {
    public static final int DEFAULT_PRIORITY = 0;
    public static final int MIN_PRIORITY = -1073741824;
    public static final int MAX_PRIORITY = 0x3FFFFFFF;
    private static final ImmutableMap<String, DispenserBehaviorTarget.Creator> TARGET_CREATORS = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{new DispenserBehaviorTarget.Creator.Unpredicated("PLACE_BLOCK", PlaceBlockTarget::getInstance, true).toEntry(), new DispenserBehaviorTarget.Creator.BlockPredicated("BLOCK_USE", BlockOnUseTarget::new, true).toEntry(), new DispenserBehaviorTarget.Creator.BlockPredicated("USE_ON_BLOCK", ItemUseOnBlockTarget::new, true).toEntry(), new DispenserBehaviorTarget.Creator.BlockPredicated("USE_ON_OFFSET_BLOCK", ItemUseOnOffsetBlockTarget::new, false).toEntry(), new DispenserBehaviorTarget.Creator.EntityPredicated("ENTITY_ON_INTERACT", EntityOnInteractTarget::new, true).toEntry(), new DispenserBehaviorTarget.Creator.EntityPredicated("USE_ON_ENTITY", ItemUseOnEntityTarget::new, true).toEntry(), new DispenserBehaviorTarget.Creator.Unpredicated("ITEM_USE", ItemUseTarget::getInstance, true).toEntry(), new DispenserBehaviorTarget.Creator.BlockAndEntityPredicated("DROP", DropTarget::new, true).toEntry(), new DispenserBehaviorTarget.Creator.BlockAndEntityPredicated("FAIL", FailTarget::new, false).toEntry()});
    private static final ImmutableSet<DispenserBehaviorTarget.Creator> DEFAULT_TARGET_CREATORS = (ImmutableSet)TARGET_CREATORS.values().stream().filter(DispenserBehaviorTarget.Creator::isDefault).collect(ImmutableSet.toImmutableSet());
    private static final Codec<DispenserBehaviorTarget.Creator> TARGET_CREATOR_CODEC = class_5699.field_41759.flatXmap(targetName -> {
        DispenserBehaviorTarget.Creator creator = (DispenserBehaviorTarget.Creator)TARGET_CREATORS.get(targetName);
        if (creator == null) {
            return DataResult.error(() -> "Unrecognized target: " + targetName);
        }
        return DataResult.success((Object)creator);
    }, creator -> DataResult.success((Object)creator.name()));
    private static final Codec<ImmutableSet<DispenserBehaviorTarget.Creator>> TARGET_CREATORS_CODEC = CodecUtil.immutableSetOf(TARGET_CREATOR_CODEC);
    private static final Codec<Integer> MIN_OR_MAX_CODEC = class_5699.field_41759.flatXmap(string -> switch (string) {
        case "MIN" -> DataResult.success((Object)-1073741824);
        case "MAX" -> DataResult.success((Object)0x3FFFFFFF);
        default -> DataResult.error(() -> "Unrecognized priority string: \"%s\"; expected \"%s\" or \"%s\"".formatted(string, "MIN", "MAX"));
    }, priority -> switch (priority) {
        case -1073741824 -> DataResult.success((Object)"MIN");
        case 0x3FFFFFFF -> DataResult.success((Object)"MAX");
        default -> DataResult.error(() -> "Priority is neither min nor max: " + priority);
    });
    private static final Codec<Integer> PRIORITY_CODEC = Codec.withAlternative((Codec)Codec.intRange((int)-1073741824, (int)0x3FFFFFFF), MIN_OR_MAX_CODEC);
    public static final MapCodec<Configurator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TARGET_CREATORS_CODEC.optionalFieldOf("targets", DEFAULT_TARGET_CREATORS).forGetter(Configurator::targetCreators), (App)TaggableId.SET_CODEC.fieldOf("items").forGetter(Configurator::itemIds), (App)PRIORITY_CODEC.optionalFieldOf("priority", (Object)0).forGetter(Configurator::priority), (App)CodecUtil.optionalWithAlternative(TaggableId.SET_CODEC, "block_allow_list", "block_white_list").forGetter(Configurator::allowedBlockIds), (App)CodecUtil.optionalWithAlternative(TaggableId.SET_CODEC, "block_deny_list", "block_black_list").forGetter(Configurator::deniedBlockIds), (App)CodecUtil.optionalWithAlternative(TaggableId.SET_CODEC, "entity_allow_list", "entity_white_list").forGetter(Configurator::allowedEntityIds), (App)CodecUtil.optionalWithAlternative(TaggableId.SET_CODEC, "entity_deny_list", "entity_black_list").forGetter(Configurator::deniedEntityIds)).apply((Applicative)instance, Configurator::new));

    public GenericDispenserBehavior.Holder resolver(class_2960 id, class_5455 registries) {
        return new GenericDispenserBehavior.Holder(id, this, registries);
    }

    public static interface Keys {
        public static final String TARGETS = "targets";
        public static final String PRIORITY = "priority";
        public static final String MAX = "MAX";
        public static final String MIN = "MIN";
        public static final String ITEMS = "items";
        public static final String BLOCK_ALLOW_LIST = "block_allow_list";
        public static final String BLOCK_DENY_LIST = "block_deny_list";
        public static final String ENTITY_ALLOW_LIST = "entity_allow_list";
        public static final String ENTITY_DENY_LIST = "entity_deny_list";
        public static final String BLOCK_WHITE_LIST = "block_white_list";
        public static final String BLOCK_BLACK_LIST = "block_black_list";
        public static final String ENTITY_WHITE_LIST = "entity_white_list";
        public static final String ENTITY_BLACK_LIST = "entity_black_list";
    }
}

