/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_2342;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_7654;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.Configurator;
import net.sssubtlety.dispenser_configurator.behavior.GenericDispenserBehavior;
import net.sssubtlety.dispenser_configurator.behavior.util.PriorityBehaviorMultiMap;

public final class ConfiguratorManager
extends class_4309<Configurator>
implements IdentifiableResourceReloadListener {
    public static final ConfiguratorManager INSTANCE = new ConfiguratorManager("dispenser_configurators");
    private PriorityBehaviorMultiMap behaviors = PriorityBehaviorMultiMap.EMPTY;
    private Map<class_2960, Configurator> cachedData;

    private ConfiguratorManager(String dataType) {
        super(Configurator.CODEC.codec(), class_7654.method_45114((String)dataType));
    }

    public boolean tryReplaceDispensation(class_2342 context, class_1799 stack, int i) {
        for (GenericDispenserBehavior behavior : this.behaviors.get(stack)) {
            stack = behavior.method_10135(context, stack);
            context.comp_1970().method_5447(i, stack);
            if (!behavior.method_27954()) continue;
            return true;
        }
        return false;
    }

    protected void apply(Map<class_2960, Configurator> cache, class_3300 manager, class_3695 profiler) {
        this.cachedData = cache;
    }

    public void resolveBehaviors(class_5455 registries) {
        if (this.cachedData == null) {
            return;
        }
        PriorityBehaviorMultiMap.Builder mapBuilder = PriorityBehaviorMultiMap.builder();
        this.cachedData.forEach((id, data) -> mapBuilder.resolveAndMap(data.resolver((class_2960)id, registries)));
        this.behaviors = mapBuilder.build();
        this.cachedData = null;
    }

    public class_2960 getFabricId() {
        return DispenserConfigurator.ID;
    }
}

