/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.Configurator;
import net.sssubtlety.dispenser_configurator.behavior.target.abstraction.DispenserBehaviorTarget;
import net.sssubtlety.dispenser_configurator.util.StringUtil;
import net.sssubtlety.dispenser_configurator.util.TaggableId;
import net.sssubtlety.dispenser_configurator.util.predicate.DualSet;
import oshi.util.Memoizer;

public class GenericDispenserBehavior
extends class_2969 {
    protected final ImmutableList<DispenserBehaviorTarget> targets;

    public GenericDispenserBehavior(ImmutableList<DispenserBehaviorTarget> targets) {
        this.targets = targets;
    }

    public class_1799 method_10135(class_2342 context, class_1799 stack) {
        if (context.comp_1967().method_8608()) {
            return stack;
        }
        this.method_27955(false);
        class_2350 facing = (class_2350)context.comp_1969().method_11654((class_2769)class_2315.field_10918);
        class_2338 facingPos = context.comp_1968().method_10093(facing);
        Supplier blockHitResult = Memoizer.memoize(() -> new class_3965(context.method_53906(), facing, facingPos, false));
        Supplier entities = Memoizer.memoize(() -> context.comp_1967().method_8333(null, new class_238(facingPos), class_1301.field_6155));
        for (DispenserBehaviorTarget target : this.targets) {
            Optional<class_1799> dispenseResult = target.tryDispensing(stack, context, facing, facingPos, blockHitResult, entities);
            if (!dispenseResult.isPresent()) continue;
            target.onSuccess(context);
            this.method_27955(true);
            return dispenseResult.orElseThrow();
        }
        return stack;
    }

    public static class Holder {
        private final class_2960 id;
        private final GenericDispenserBehavior behavior;
        private final boolean exclusive;
        private final ImmutableSet<class_1792> items;
        private final int priority;
        private final DualSet<class_2248> blockPredicate;
        private final DualSet<class_1299<?>> entityPredicate;

        private static <E> DualSet<E> resolveDualSet(class_2960 id, Optional<ImmutableSet<TaggableId>> allowedIds, Optional<ImmutableSet<TaggableId>> deniedIds, class_5321<? extends class_2378<E>> registryKey, class_5455 registries) {
            DataResult allowedBlocks = TaggableId.resolveEntries((Collection)allowedIds.orElse((ImmutableSet<TaggableId>)ImmutableSet.of()), registryKey, registries);
            DataResult deniedBlocks = TaggableId.resolveEntries((Collection)deniedIds.orElse((ImmutableSet<TaggableId>)ImmutableSet.of()), registryKey, registries);
            return new DualSet(Holder.flattenAndLogError(id, "block_allow_list", allowedBlocks), Holder.flattenAndLogError(id, "block_deny_list", deniedBlocks));
        }

        private static <E> ImmutableSet<E> flattenAndLogError(class_2960 id, String key, DataResult<List<E>> entries) {
            return entries.resultOrPartial(error -> DispenserConfigurator.LOGGER.error("Error in {} of configurator \"{}\": {}", new Object[]{key, id, error})).map(ImmutableSet::copyOf).orElseGet(ImmutableSet::of);
        }

        public Holder(class_2960 id, Configurator configurator, class_5455 registries) {
            this.id = id;
            this.items = Holder.flattenAndLogError(id, "items", TaggableId.resolveEntries(configurator.itemIds(), class_7924.field_41197, registries));
            this.priority = configurator.priority();
            this.blockPredicate = Holder.resolveDualSet(id, configurator.allowedBlockIds(), configurator.deniedBlockIds(), class_7924.field_41254, registries);
            this.entityPredicate = Holder.resolveDualSet(id, configurator.allowedEntityIds(), configurator.deniedEntityIds(), class_7924.field_41266, registries);
            ImmutableList.Builder targetsBuilder = ImmutableList.builder();
            boolean usedBlockPredicate = false;
            boolean usedEntityPredicate = false;
            DispenserBehaviorTarget exclusiveTarget = null;
            LinkedList postExclusiveTargets = new LinkedList();
            for (DispenserBehaviorTarget.Creator creator : configurator.targetCreators()) {
                DispenserBehaviorTarget.Creator.Creation<DispenserBehaviorTarget> creation = creator.create(this.blockPredicate, this.entityPredicate);
                usedBlockPredicate |= creation.blockPredicated;
                usedEntityPredicate |= creation.entityPredicated;
                Object target = creation.target;
                if (exclusiveTarget == null) {
                    if (((DispenserBehaviorTarget)target).isExclusive()) {
                        exclusiveTarget = target;
                    }
                    targetsBuilder.add(target);
                    continue;
                }
                postExclusiveTargets.add(target);
            }
            if (!postExclusiveTargets.isEmpty()) {
                class_2357.field_34020.error("Exclusive target \"{}\" is followed by more targets; skipping:{}", (Object)exclusiveTarget.getName(), (Object)StringUtil.zipLineTabs(postExclusiveTargets.stream().map(DispenserBehaviorTarget::getName)));
            }
            ImmutableList targets = targetsBuilder.build();
            Supplier formattedTargetNames = Memoizer.memoize(() -> StringUtil.zipLineTabs(targets.stream().map(DispenserBehaviorTarget::getName)));
            if (!usedBlockPredicate && !this.blockPredicate.isEmpty()) {
                class_2357.field_34020.error("Block list specified but no target uses block lists; targets:{}", formattedTargetNames.get());
            }
            if (!usedEntityPredicate && !this.entityPredicate.isEmpty()) {
                class_2357.field_34020.error("Entity list specified but no target uses entity lists; targets:{}", formattedTargetNames.get());
            }
            this.behavior = new GenericDispenserBehavior((ImmutableList<DispenserBehaviorTarget>)targets);
            this.exclusive = exclusiveTarget != null;
        }

        public class_2960 getId() {
            return this.id;
        }

        public GenericDispenserBehavior getBehavior() {
            return this.behavior;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public ImmutableSet<class_1792> getItems() {
            return this.items;
        }

        public boolean intersects(Holder other) {
            return this.blockPredicate.intersects(other.blockPredicate) || this.entityPredicate.intersects(other.entityPredicate);
        }

        public int comparePriority(Holder other) {
            if (this.priority == other.priority) {
                boolean otherLow;
                boolean thisLow = this.isLowPriority();
                if (thisLow == (otherLow = other.isLowPriority())) {
                    return 0;
                }
                if (thisLow) {
                    return 1;
                }
                return -1;
            }
            return other.priority - this.priority;
        }

        private boolean isLowPriority() {
            return this.blockPredicate.allowSet.isEmpty() && this.entityPredicate.allowSet.isEmpty();
        }
    }
}

