/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.sssubtlety.dispenser_configurator.util.CodecUtil;
import net.sssubtlety.dispenser_configurator.util.StringUtil;

public record TaggableId(class_2960 id, boolean isTag) {
    public static final String TAG_PREFIX = "#";
    public static final Codec<TaggableId> CODEC = class_5699.field_41759.xmap(TaggableId::of, TaggableId::toString);
    public static final Codec<ImmutableSet<TaggableId>> SET_CODEC = CodecUtil.immutableSetOf(CODEC);

    public static TaggableId of(String idString) {
        boolean isTag = idString.startsWith(TAG_PREFIX);
        return new TaggableId(class_2960.method_60654((String)(isTag ? idString.substring(1) : idString)), isTag);
    }

    public static <E> DataResult<List<E>> resolveEntries(Collection<TaggableId> ids, class_5321<? extends class_2378<E>> registryKey, class_5455 registries) {
        class_2378 registry = registries.method_30530(registryKey);
        ArrayList missingIds = new ArrayList();
        List entries = ids.stream().flatMap(taggable -> {
            if (taggable.isTag()) {
                Optional holderSet = registry.method_46733(class_6862.method_40092((class_5321)registryKey, (class_2960)taggable.id()));
                if (holderSet.isPresent()) {
                    return ((class_6885.class_6888)holderSet.orElseThrow()).method_40239().map(class_6880::comp_349);
                }
                missingIds.add(taggable);
            } else {
                Optional entry = registry.method_17966(taggable.id());
                if (entry.isPresent()) {
                    return Stream.of(entry.orElseThrow());
                }
                missingIds.add(taggable);
            }
            return Stream.empty();
        }).toList();
        return missingIds.isEmpty() ? DataResult.success(entries) : DataResult.error(() -> "Missing \"%s\" entries:%s".formatted(registryKey.method_29177(), StringUtil.zipLineTabs(missingIds.stream().map(TaggableId::toString))), entries);
    }

    @Override
    public String toString() {
        return (this.isTag ? TAG_PREFIX : "") + this.id.toString();
    }
}

