/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior.target;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.sssubtlety.dispenser_configurator.behavior.target.abstraction.DispenserBehaviorTarget;
import net.sssubtlety.dispenser_configurator.behavior.util.DispenserFakePlayer;

public class ItemUseOnOffsetBlockTarget
extends DispenserBehaviorTarget {
    public static final String NAME = "USE_ON_OFFSET_BLOCK";
    private final Predicate<class_2248> blockPredicate;

    public ItemUseOnOffsetBlockTarget(Predicate<class_2248> blockPredicate) {
        this.blockPredicate = blockPredicate;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Optional<class_1799> tryDispensing(class_1799 stack, class_2342 dispenserPointer, class_2350 facing, class_2338 facingPos, Supplier<class_3965> blockHitResult, Supplier<List<class_1297>> entities) {
        class_3218 world = dispenserPointer.comp_1967();
        if (!world.method_8320(facingPos).method_26215()) {
            return Optional.empty();
        }
        class_243 facingCenter = facingPos.method_46558();
        return ((ImmutableList)Offset.ORDERS_BY_DIRECTION.get((Object)facing)).stream().map(offset -> {
            class_2680 offsetState = world.method_8320(facingPos.method_10093(offset.direction));
            if (offsetState.method_26215() || !this.blockPredicate.test(offsetState.method_26204())) {
                return Optional.empty();
            }
            return DispenserFakePlayer.fakePlayerInteraction(stack, dispenserPointer, (player, heldStack, hand) -> heldStack.method_7981(offset.createContext(facingPos, facingCenter, player)));
        }).filter(Optional::isPresent).map(Optional::orElseThrow).findFirst();
    }

    private static enum Offset {
        UP(class_2350.field_11036),
        DOWN(class_2350.field_11033),
        NORTH(class_2350.field_11043),
        SOUTH(class_2350.field_11035),
        EAST(class_2350.field_11034),
        WEST(class_2350.field_11039);

        public static final ImmutableMap<class_2350, ImmutableList<Offset>> ORDERS_BY_DIRECTION;
        public final class_2350 direction;
        public final class_243 face;

        private static Offset byDirection(class_2350 direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11036 -> UP;
                case class_2350.field_11033 -> DOWN;
                case class_2350.field_11043 -> NORTH;
                case class_2350.field_11035 -> SOUTH;
                case class_2350.field_11034 -> EAST;
                case class_2350.field_11039 -> WEST;
            };
        }

        private Offset(class_2350 direction) {
            this.direction = direction;
            this.face = new class_243(direction.method_23955().mul(0.5f));
        }

        public class_1838 createContext(class_2338 facingPos, class_243 facingCenter, class_3222 player) {
            return new class_1838((class_1657)player, class_1268.field_5808, new class_3965(facingCenter.method_1019(this.face), this.direction.method_10153(), facingPos.method_10093(this.direction), false));
        }

        static {
            ORDERS_BY_DIRECTION = (ImmutableMap)class_2350.method_42013().map(direction -> {
                ImmutableList.Builder order = ImmutableList.builder();
                order.add((Object)Offset.byDirection(direction));
                if (direction.method_10166() == class_2350.class_2351.field_11052) {
                    order.addAll(class_2350.class_2353.field_11062.method_29716().map(Offset::byDirection).toList());
                } else {
                    order.add((Object)Offset.byDirection(class_2350.field_11033));
                    order.add((Object)Offset.byDirection(class_2350.field_11036));
                    order.add((Object)Offset.byDirection(direction.method_10160()));
                    order.add((Object)Offset.byDirection(direction.method_10170()));
                }
                order.add((Object)Offset.byDirection(direction.method_10153()));
                return Map.entry(direction, order.build());
            }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

