/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior.util;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2371;
import net.minecraft.class_2601;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.sssubtlety.dispenser_configurator.util.StringUtil;

public class DispenserFakePlayer
extends FakePlayer {
    public static final class_1268 INTERACTION_HAND = class_1268.field_5808;
    private static final Map<class_3218, GameProfile> PROFILES = new HashMap<class_3218, GameProfile>();
    private static final Map<class_3218, DispenserFakePlayer> PLAYERS = new MapMaker().weakValues().makeMap();
    private static final class_2347 ITEM_DISPENSER_BEHAVIOR = new class_2347();

    public static Optional<class_1799> fakePlayerInteraction(class_1799 stack, class_2342 dispenserPointer, PlayerInteraction interaction) {
        DispenserFakePlayer player = DispenserFakePlayer.getPlayer(dispenserPointer.comp_1967());
        player.method_6122(INTERACTION_HAND, stack);
        boolean accepted = interaction.interact((class_3222)player, stack, INTERACTION_HAND).method_23665();
        class_1799 mainHandStack = player.method_6047();
        player.method_6122(INTERACTION_HAND, class_1799.field_8037);
        if (accepted) {
            player.transferOrDropInventory(dispenserPointer);
            return Optional.of(mainHandStack);
        }
        return Optional.empty();
    }

    private static DispenserFakePlayer getPlayer(class_3218 world) {
        return PLAYERS.computeIfAbsent(world, unused1 -> new DispenserFakePlayer(world, PROFILES.computeIfAbsent(world, unused2 -> new GameProfile(UUID.randomUUID(), "[%s in %s]".formatted("dispenser_configurator", StringUtil.toPathSafeString(world.method_27983().method_29177()))))));
    }

    private static boolean transfer(class_2601 dispenserBlockEntity, class_1799 stack) {
        int invSize;
        int firstEmptySlot = invSize = dispenserBlockEntity.method_5439();
        boolean stackable = stack.method_7946();
        for (int slot = 0; slot < invSize; ++slot) {
            class_1799 slotStack = dispenserBlockEntity.method_5438(slot);
            if (stackable) {
                int transferCount;
                if (slotStack.method_7960()) {
                    if (slot >= firstEmptySlot) continue;
                    firstEmptySlot = slot;
                    continue;
                }
                if (!class_1799.method_31577((class_1799)stack, (class_1799)slotStack) || (transferCount = Math.min(slotStack.method_7914() - slotStack.method_7947(), stack.method_7947())) <= 0) continue;
                slotStack.method_7933(transferCount);
                stack.method_7934(transferCount);
                if (!stack.method_7960()) continue;
                break;
            }
            if (!slotStack.method_7960()) continue;
            firstEmptySlot = slot;
            break;
        }
        if (stack.method_7960()) {
            return true;
        }
        if (firstEmptySlot < invSize) {
            dispenserBlockEntity.method_5447(firstEmptySlot, stack.method_51164());
            return true;
        }
        return false;
    }

    protected DispenserFakePlayer(class_3218 world, GameProfile profile) {
        super(world, profile);
    }

    protected class_1796 method_7265() {
        return FakeCooldownManager.INSTANCE;
    }

    private void transferOrDropInventory(class_2342 dispenserPointer) {
        class_2601 dispenserBlockEntity = dispenserPointer.comp_1970();
        if (dispenserBlockEntity != null) {
            class_2371 playerMainInventory = this.method_31548().field_7547;
            for (int i = 0; i < playerMainInventory.size(); ++i) {
                if (i == this.method_31548().field_7545) continue;
                class_1799 stack = (class_1799)playerMainInventory.get(i);
                if (stack.method_7960()) break;
                if (DispenserFakePlayer.transfer(dispenserBlockEntity, stack)) {
                    playerMainInventory.set(i, (Object)class_1799.field_8037);
                    continue;
                }
                ITEM_DISPENSER_BEHAVIOR.dispense(dispenserPointer, stack);
            }
        }
    }

    @FunctionalInterface
    public static interface PlayerInteraction {
        public class_1269 interact(class_3222 var1, class_1799 var2, class_1268 var3);
    }

    private static final class FakeCooldownManager
    extends class_1796 {
        public static final FakeCooldownManager INSTANCE = new FakeCooldownManager();

        private FakeCooldownManager() {
        }

        public boolean method_7904(class_1799 stack) {
            return false;
        }

        public float method_7905(class_1799 stack, float partialTicks) {
            return 0.0f;
        }

        public void method_7903() {
        }

        public void method_62835(class_1799 stack, int duration) {
        }

        public void method_7906(class_2960 id, int duration) {
        }

        public void method_7900(class_2960 id) {
        }
    }
}

