/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.dispenser_configurator.behavior.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import net.sssubtlety.dispenser_configurator.DispenserConfigurator;
import net.sssubtlety.dispenser_configurator.behavior.GenericDispenserBehavior;
import net.sssubtlety.dispenser_configurator.behavior.util.PrioritizedBehaviorHolders;

public class PriorityBehaviorMultiMap {
    public static final PriorityBehaviorMultiMap EMPTY = new PriorityBehaviorMultiMap((ImmutableMap<class_1792, ImmutableList<GenericDispenserBehavior>>)ImmutableMap.of());
    private final ImmutableMap<class_1792, ImmutableList<GenericDispenserBehavior>> behaviors;

    public static Builder builder() {
        return new Builder();
    }

    private PriorityBehaviorMultiMap(ImmutableMap<class_1792, ImmutableList<GenericDispenserBehavior>> behaviors) {
        this.behaviors = behaviors;
    }

    public Iterable<GenericDispenserBehavior> get(class_1799 stack) {
        ImmutableList itemBehaviors = (ImmutableList)this.behaviors.get((Object)stack.method_7909());
        return itemBehaviors == null ? Collections.emptyList() : itemBehaviors;
    }

    public static class Builder {
        private final Map<class_1792, PrioritizedBehaviorHolders> holders = new HashMap<class_1792, PrioritizedBehaviorHolders>();

        private Builder() {
        }

        public PriorityBehaviorMultiMap build() {
            return new PriorityBehaviorMultiMap((ImmutableMap<class_1792, ImmutableList<GenericDispenserBehavior>>)((ImmutableMap)this.holders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (ImmutableList)((PrioritizedBehaviorHolders)entry.getValue()).stream().map(GenericDispenserBehavior.Holder::getBehavior).collect(ImmutableList.toImmutableList())))));
        }

        public void resolveAndMap(GenericDispenserBehavior.Holder holder) {
            for (class_1792 item : holder.getItems()) {
                this.holders.computeIfAbsent(item, unused -> new PrioritizedBehaviorHolders()).addOrFindConflict(holder).ifPresent(conflict -> DispenserConfigurator.LOGGER.error("Conflicting exclusive configurators found for item: \"{}\"\n\tConfigurators: \"{}\", \"{}\"\n\tSkipping: \"{}\"\n", new Object[]{class_7923.field_41178.method_10221((Object)item), conflict.getId(), holder.getId(), holder.getId()}));
            }
        }
    }
}

