#version 130

#include "/settings.glsl"

in vec2 texcoord;

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float frameTimeCounter;
uniform float viewWidth, viewHeight;

uniform vec3 cameraPosition;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;

vec2 viewR = vec2(viewWidth, viewHeight);

const float FADE_TIME = 1.0;

vec3 projectAndDivide(mat4 projectionMatrix, vec3 position){
  vec4 homPos = projectionMatrix * vec4(position, 1.0);
  return homPos.xyz / homPos.w;
}

float hash(vec2 p) {
    p = fract(p * vec2(123.34, 456.21));
    p += dot(p, p + 45.32);
    return fract(p.x * p.y);
}

void main()
{
	float depth = texture2D(depthtex0, texcoord).r;
	if(depth == 1.0){
		vec3(0);
	}

	vec3 albedo = texture2D(colortex0, texcoord).rgb;
	float grainSize = GRAIN_SIZE;
	float aspect = viewWidth / viewHeight;
	vec2 scaledUV = vec2(texcoord.x * aspect, texcoord.y);
	vec2 pixelated = floor(scaledUV * grainSize) / grainSize;
	vec2 finalUV = vec2(pixelated.x / aspect, pixelated.y);
	float noise = hash(finalUV + frameTimeCounter * 0.5);
	float noiseMask = step(NOISE_MASK, noise);
	albedo = mix(vec3(0) * albedo, albedo, noiseMask);
	
	vec3 NDCPos = vec3(texcoord.xy, depth) * 2.0 - 1.0;
	vec3 viewPos = projectAndDivide(gbufferProjectionInverse, NDCPos);
    
    float scanPos = fract(frameTimeCounter * SCAN_SPEED);
    float currentScanY = 1.0 - scanPos; // от 1.0 (верх) до 0.0 (низ)
    
    vec2 screenPos = texcoord;
    float fragmentY = screenPos.y;

    float timeSinceScan = (fragmentY - currentScanY);
    if (timeSinceScan < 0.0) timeSinceScan += 1.0;
    float fade = 1.0 - clamp(timeSinceScan / FADE_TIME, 0.0, 1.0);
    
	vec3 color = mix(vec3(1.0), vec3(0.0), length(viewPos)/32) * fade;
	
    /*DRAWBUFFERS:0*/
    gl_FragData[0].rgb = (color * 0.5) + (albedo * color);
}
