/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.woukie.createmissiles.block.controlpanel.ControlPanelBlockEntity;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlockEntity;
import net.woukie.createmissiles.registry.BlockEntities;

public class MultiblockHelper {
    public static class_2338 findCorner(class_2338 origin, class_2350 facing, class_1937 level) {
        class_2350 right = facing.method_10170();
        for (int offset = 0; offset < 3; ++offset) {
            class_2338 corner = origin.method_10093(facing).method_10079(right, -offset);
            if (!MultiblockHelper.checkForLaunchPad(corner, right, facing, level)) continue;
            return corner;
        }
        return null;
    }

    public static class_2586 findEdgeBlock(class_2586 origin, class_1937 level, class_2591<?> type) {
        class_2350 facing = ((class_2350)origin.method_11010().method_11654((class_2769)class_2383.field_11177)).method_10153();
        class_2338 corner = MultiblockHelper.findCorner(origin.method_11016(), facing, level);
        return MultiblockHelper.findEdgeBlock(corner, facing, level, type);
    }

    public static class_2586 findEdgeBlock(class_2338 corner, class_2350 facing, class_1937 level, class_2591<?> type) {
        if (corner == null) {
            return null;
        }
        class_2350 right = facing.method_10170();
        for (int i = 0; i < 3; ++i) {
            class_2338 leftEdge = corner.method_10079(right, -1).method_10079(facing, i);
            class_2586 leftEntity = level.method_8321(leftEdge);
            if (leftEntity != null && leftEntity.method_11017() == type && leftEntity.method_11010().method_11654((class_2769)class_2383.field_11177) == right.method_10153()) {
                return leftEntity;
            }
            class_2338 farEdge = corner.method_10079(facing, 3).method_10079(right, i);
            class_2586 farEntity = level.method_8321(farEdge);
            if (farEntity != null && farEntity.method_11017() == type && farEntity.method_11010().method_11654((class_2769)class_2383.field_11177) == facing) {
                return farEntity;
            }
            class_2338 backEdge = corner.method_10079(facing, -1).method_10079(right, i);
            class_2586 backEntity = level.method_8321(backEdge);
            if (backEntity != null && backEntity.method_11017() == type && backEntity.method_11010().method_11654((class_2769)class_2383.field_11177) == facing.method_10153()) {
                return backEntity;
            }
            class_2338 rightEdge = corner.method_10079(right, 3).method_10079(facing, i);
            class_2586 rightEntity = level.method_8321(rightEdge);
            if (rightEntity == null || rightEntity.method_11017() != type || rightEntity.method_11010().method_11654((class_2769)class_2383.field_11177) != right) continue;
            return rightEntity;
        }
        return null;
    }

    private static boolean checkForLaunchPad(class_2338 corner, class_2350 right, class_2350 facing, class_1937 level) {
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                class_2338 targetBlock = corner.method_10079(right, x).method_10079(facing, z);
                class_2586 blockEntity = level.method_8321(targetBlock);
                if (blockEntity instanceof LaunchPadBlockEntity) continue;
                return false;
            }
        }
        return true;
    }

    public static class_2338 findCornerFromLaunchPad(class_1937 level, class_2338 pos) {
        class_2350 forward = class_2350.field_11043;
        class_2350 right = forward.method_10170();
        class_2338 corner = pos;
        while (level.method_8321(corner.method_10093(forward)) instanceof LaunchPadBlockEntity) {
            corner = corner.method_10093(forward);
        }
        while (level.method_8321(corner.method_10093(right)) instanceof LaunchPadBlockEntity) {
            corner = corner.method_10093(right);
        }
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                if (level.method_8321(corner.method_10079(forward, -x).method_10079(right, -z)) instanceof LaunchPadBlockEntity) continue;
                return null;
            }
        }
        return corner;
    }

    public static ControlPanelBlockEntity findControlPanelFromLaunchPad(class_1937 level, class_2338 pos) {
        class_2338 corner = MultiblockHelper.findCornerFromLaunchPad(level, pos);
        if (corner == null) {
            return null;
        }
        class_2586 blockEntity = MultiblockHelper.findEdgeBlock(corner, class_2350.field_11043.method_10153(), level, (class_2591)BlockEntities.CONTROL_PANEL.get());
        if (blockEntity != null) {
            return (ControlPanelBlockEntity)blockEntity;
        }
        return null;
    }
}

