/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.woukie.createmissiles.inventory.ControlPanelMenu;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.recipe.MissilePartRecipe;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;

public class ControlPanelScreen
extends class_465<ControlPanelMenu> {
    private static final class_2960 BACKGROUND = new class_2960("createmissiles", "textures/gui/container/control_panel.png");
    private static final class_2960 COVER_LEFT = new class_2960("createmissiles", "textures/gui/sprites/container/cover_l.png");
    private static final class_2960 COVER_RIGHT = new class_2960("createmissiles", "textures/gui/sprites/container/cover_r.png");
    private static final class_2960 BUTTON = new class_2960("createmissiles", "textures/gui/sprites/container/button.png");
    private static final class_2960 BUTTON_HOVER = new class_2960("createmissiles", "textures/gui/sprites/container/button_hover.png");
    private static final int consoleLeft = 8;
    private static final int consoleTop = 18;
    private static final int consoleWidth = 105;
    private static final int consoleHeight = 52;
    private static final int buttonLeft = 116;
    private static final int buttonTop = 18;
    private static final int buttonWidth = 52;
    private static final int buttonHeight = 52;
    private static final int coverLeft = 116;
    private static final int coverTop = 18;
    private static final int coverWidth = 26;
    private static final int coverHeight = 52;
    private static final List<Character> textAnimatePallette = List.of(Character.valueOf('\u2588'), Character.valueOf('\u2593'), Character.valueOf('\u2592'), Character.valueOf('\u2591'), Character.valueOf(' '));
    private static final double textAnimateWaveLenth = 3.0;
    private double currentOpenPercent = 0.0;
    private double currentScrollPosition = 0.0;
    private final long openedTime = System.currentTimeMillis();

    public ControlPanelScreen(ControlPanelMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)abstractContainerMenu, inventory, component);
    }

    public void method_25394(@NotNull class_332 gui, int i, int j, float f) {
        super.method_25394(gui, i, j, f);
        this.method_2380(gui, i, j);
    }

    private void renderButton(@NotNull class_332 gui, boolean buttonOpen, double mouseX, double mouseY) {
        double speed = 0.01f;
        double targetOpenPercent = buttonOpen ? 1.0 : 0.0;
        this.currentOpenPercent += targetOpenPercent > this.currentOpenPercent ? speed : -speed;
        double adjusted = buttonOpen ? this.easeOutBounce(this.currentOpenPercent) : this.easeInBounce(this.currentOpenPercent);
        int width = (int)(adjusted * 26.0 + 0.5);
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 2.0f);
        gui.method_25290(COVER_LEFT, 116, 18, (float)width, 0.0f, 26 - width, 52, 26, 52);
        gui.method_25290(COVER_RIGHT, 142 + width, 18, 0.0f, 0.0f, 26 - width, 52, 26, 52);
        gui.method_51448().method_22909();
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(0.0f, 0.0f, 1.0f);
        class_2960 resource = buttonOpen && this.method_2378(116, 18, 52, 52, mouseX, mouseY) ? BUTTON_HOVER : BUTTON;
        gui.method_25290(resource, 116, 18, 0.0f, 0.0f, 52, 52, 52, 52);
        gui.method_51448().method_22909();
    }

    private double easeOutBounce(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 1.0 / d1) {
            return n1 * x * x;
        }
        if (x < 2.0 / d1) {
            return n1 * (x -= 1.5 / d1) * x + 0.75;
        }
        if (x < 2.5 / d1) {
            return n1 * (x -= 2.25 / d1) * x + 0.9375;
        }
        return n1 * (x -= 2.625 / d1) * x + 0.984375;
    }

    private double easeInBounce(double x) {
        return 1.0 - this.easeOutBounce(1.0 - x);
    }

    private boolean renderLogs(class_332 gui) {
        ArrayList<Text> text = new ArrayList<Text>();
        boolean launchPadValid = this.addLaunchPadStatus(text);
        boolean navigationPanelValid = this.addNavigationPanelStatus(text);
        boolean assemblyPanelValid = this.addAssemblyPanelStatus(text);
        int lineCount = 9;
        class_638 level = this.field_22787 != null ? this.field_22787.field_1687 : null;
        Map<MissileIngredient, Integer> warheadItemsLeft = MissilePartRecipe.getRemainingItems(PartTypes.get(((ControlPanelMenu)this.method_17577()).getWarhead()), (class_1937)level, (List<class_1799>)((ControlPanelMenu)this.method_17577()).method_7602());
        Map<MissileIngredient, Integer> chassisItemsLeft = MissilePartRecipe.getRemainingItems(PartTypes.get(((ControlPanelMenu)this.method_17577()).getChassis()), (class_1937)level, (List<class_1799>)((ControlPanelMenu)this.method_17577()).method_7602());
        Map<MissileIngredient, Integer> thrusterItemsLeft = MissilePartRecipe.getRemainingItems(PartTypes.get(((ControlPanelMenu)this.method_17577()).getThruster()), (class_1937)level, (List<class_1799>)((ControlPanelMenu)this.method_17577()).method_7602());
        int warheadPercent = MissilePartRecipe.getBuildPercentage(warheadItemsLeft);
        int chassisPercent = MissilePartRecipe.getBuildPercentage(chassisItemsLeft);
        int thrusterPercent = MissilePartRecipe.getBuildPercentage(thrusterItemsLeft);
        text.add(new Text("\n" + class_2561.method_43471((String)"gui.createmissiles.control_panel.warhead_title").getString() + ": ", Color.WHITE));
        text.add(new Text(warheadPercent + "%\n", warheadPercent == 0 ? Color.RED : (warheadPercent == 100 ? Color.GREEN : Color.YELLOW)));
        if (warheadItemsLeft != null) {
            lineCount += this.writeIngredientStatus(text, warheadItemsLeft);
        }
        text.add(new Text("\n" + class_2561.method_43471((String)"gui.createmissiles.control_panel.chassis_title").getString() + ": ", Color.WHITE));
        text.add(new Text(chassisPercent + "%\n", chassisPercent == 0 ? Color.RED : (chassisPercent == 100 ? Color.GREEN : Color.YELLOW)));
        if (chassisItemsLeft != null) {
            lineCount += this.writeIngredientStatus(text, chassisItemsLeft);
        }
        text.add(new Text("\n" + class_2561.method_43471((String)"gui.createmissiles.control_panel.thruster_title").getString() + ": ", Color.WHITE));
        text.add(new Text(thrusterPercent + "%\n", thrusterPercent == 0 ? Color.RED : (thrusterPercent == 100 ? Color.GREEN : Color.YELLOW)));
        if (thrusterItemsLeft != null) {
            lineCount += this.writeIngredientStatus(text, thrusterItemsLeft);
        }
        gui.method_51448().method_22903();
        gui.method_51448().method_46416(8.0f, 18.0f, 0.0f);
        double lineHeight = 4.5;
        this.currentScrollPosition = Math.max(-lineHeight * (double)lineCount - 1.0 + 52.0, this.currentScrollPosition);
        this.currentScrollPosition = Math.min(0.0, this.currentScrollPosition);
        gui.method_51448().method_22904(0.0, this.currentScrollPosition, 0.0);
        gui.method_51448().method_22905(0.5f, 0.5f, 1.0f);
        gui.method_44379(8 + this.field_2776, 18 + this.field_2800, 8 + this.field_2776 + 105, 18 + this.field_2800 + 52);
        this.animateText(text);
        class_5348 formattedText = class_5348.method_29432(text.stream().map(a -> class_5348.method_29431((String)a.text, (class_2583)a.getStyle())).toList());
        gui.method_51440(this.field_22793, formattedText, 2, 2, 206, 100);
        gui.method_44380();
        gui.method_51448().method_22909();
        return launchPadValid && navigationPanelValid && assemblyPanelValid && chassisPercent == 100 && warheadPercent == 100 && thrusterPercent == 100;
    }

    private void animateText(List<Text> text) {
        long timePassed = System.currentTimeMillis() - this.openedTime;
        int hideAfter = (int)(timePassed / 10L);
        int currentCharacter = 0;
        for (Text line : text) {
            StringBuilder obuscated = new StringBuilder();
            char[] cArray = line.text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                if (currentCharacter <= hideAfter) {
                    if (!character.equals(Character.valueOf('\n'))) {
                        int distance = hideAfter - currentCharacter;
                        double proportionThroughList = (double)(distance += (int)(Math.random() * 3.0 - 1.5)) / ((double)textAnimatePallette.size() * 3.0);
                        if ((proportionThroughList = Math.max(0.0, proportionThroughList)) <= 1.0) {
                            int palletteIndex = (int)(proportionThroughList * (double)(textAnimatePallette.size() - 1));
                            character = textAnimatePallette.get(palletteIndex);
                        }
                    }
                    obuscated.append(character);
                }
                ++currentCharacter;
            }
            line.text = obuscated.toString();
        }
    }

    private boolean addLaunchPadStatus(List<Text> text) {
        String title = class_2561.method_43471((String)"gui.createmissiles.control_panel.launch_pad_title").getString();
        text.add(new Text(title + ": ", Color.WHITE));
        if (!((ControlPanelMenu)this.method_17577()).launchPadExists()) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_launch_pad").getString() + "\n";
            text.add(new Text(status, Color.RED));
            return false;
        }
        if (!((ControlPanelMenu)this.method_17577()).launchPadPowered()) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.launch_pad_no_power").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.valid").getString() + "\n";
        text.add(new Text(status, Color.GREEN));
        return true;
    }

    private boolean addNavigationPanelStatus(List<Text> text) {
        String title = class_2561.method_43471((String)"gui.createmissiles.control_panel.navigation_panel_title").getString();
        text.add(new Text(title + ": ", Color.WHITE));
        if (!((ControlPanelMenu)this.method_17577()).navigationPanelExists()) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_navigation_panel").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        if (!((ControlPanelMenu)this.method_17577()).hasDestination()) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_destination").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.valid").getString() + "\n";
        text.add(new Text(status, Color.GREEN));
        return true;
    }

    private boolean addAssemblyPanelStatus(List<Text> text) {
        String title = class_2561.method_43471((String)"gui.createmissiles.control_panel.assembly_panel_title").getString();
        text.add(new Text(title + ": ", Color.WHITE));
        if (!((ControlPanelMenu)this.method_17577()).assemblyPanelExists()) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_assembly_panel").getString() + "\n";
            text.add(new Text(status, Color.RED));
            return false;
        }
        class_1799 warheadStack = ((ControlPanelMenu)this.method_17577()).getWarhead();
        class_1799 chassisStack = ((ControlPanelMenu)this.method_17577()).getChassis();
        class_1799 thrusterStack = ((ControlPanelMenu)this.method_17577()).getThruster();
        if (warheadStack == null) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_warhead").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        if (chassisStack == null) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_chassis").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        if (thrusterStack == null) {
            String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.no_thruster").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        String status = class_2561.method_43471((String)"gui.createmissiles.control_panel.valid").getString() + "\n";
        text.add(new Text(status, Color.GREEN));
        return true;
    }

    private int writeIngredientStatus(List<Text> text, Map<MissileIngredient, Integer> ingredients) {
        AtomicInteger increment = new AtomicInteger();
        ingredients.forEach((ingredient, left) -> {
            int required = ingredient.count();
            int have = required - left;
            List<class_1799> items = ingredient.getAllValidItems();
            class_2561[] names = items.stream().map(class_1799::method_7954).toList().toArray(new class_2561[0]);
            String name = names[(int)((float)class_156.method_658() / 1000.0f) % names.length].getString();
            text.add(new Text("> " + name.substring(1, name.length() - 1) + " ", Color.WHITE));
            text.add(new Text(have + "/" + required + "\n", have == required ? Color.GREEN : (have == 0 ? Color.RED : Color.YELLOW)));
            increment.addAndGet(name.length() / 32 + 1);
        });
        return increment.get();
    }

    public boolean method_25401(double d, double e, double f) {
        this.currentScrollPosition += f * 4.0;
        return true;
    }

    protected void method_2389(class_332 gui, float f, int i, int j) {
        gui.method_51448().method_22903();
        gui.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        gui.method_25302(BACKGROUND, 0, 0, 0, 0, this.field_2792, this.field_2779);
        boolean buttonOpen = this.renderLogs(gui);
        this.renderButton(gui, buttonOpen, i, j);
        gui.method_51448().method_22909();
    }

    public boolean method_25402(double x, double y, int i) {
        if (this.method_2378(116, 18, 52, 52, x, y)) {
            ((ControlPanelMenu)this.method_17577()).clickLaunch();
        }
        return super.method_25402(x, y, i);
    }

    private static class Text {
        public String text;
        public Color color;

        Text(String text, Color color) {
            this.text = text;
            this.color = color;
        }

        public class_2583 getStyle() {
            return switch (this.color.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 3 -> class_2583.field_24360.method_36139(0xFFFFFF);
                case 0 -> class_2583.field_24360.method_36139(65280);
                case 1 -> class_2583.field_24360.method_36139(0xFFFF00);
                case 2 -> class_2583.field_24360.method_36139(0xFF0000);
            };
        }
    }

    private static enum Color {
        GREEN,
        YELLOW,
        RED,
        WHITE;

    }
}

